#!/bin/sh
# 
# PRIORITY MANAGER V1.8 BY BUYUKBANG
#
#########################################################################################
#
# PLEASE READ FOLLOWING FILE FOR MORE INFORMATION: /PLUGINS/PriorityManager/readme.txt
#
#########################################################################################

if [ -f /DISK2/etc/PriorityManagerSettings.txt ]; then
   dos2unix /DISK2/etc/PriorityManagerSettings.txt
   . /DISK2/etc/PriorityManagerSettings.txt
else
   exit
fi

ln="/PLUGINS/PriorityManager/busybox ln" 
nohup="/PLUGINS/PriorityManager/busybox nohup"
LOG_STARTED=0

gettype() {
  if [ -L "$1" ]; then
    echo "softlink"
  elif [ -f "$1" ]; then
    echo "file"
  elif [ -d "$1" ]; then
    echo "directory"
  else
    echo "unknown"
  fi
}

exists() {
   a=0
   b=0
   if [ -e "$1" -o -L "$1" ]; then
      a=1
   fi
   if [ -e "$2" -o -L "$1" ]; then
      b=1
   fi

   if [ "$a" == "1" ] && [ "$b" == "0" ]; then
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "$2 DOES NOT EXIST" >> /tmp/PriorityManager_IsRunning
      return 1
   elif [ "$a" == "0" ] && [ "$b" == "1" ]; then
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "$1 DOES NOT EXIST" >> /tmp/PriorityManager_IsRunning
      return 1
   elif [ "$a" == "1" ] && [ "$b" == "1" ]; then
      return 0
   else
     return 2
   fi
}

comparefile() {
  cmp -s "$1" "$2"
  if [ $? -gt 0 ]; then
    echo $"`date '+%H:%M:%S %m/%d/%y'`": "$1 DIFFERENT FROM $2" >> /tmp/PriorityManager_IsRunning
  fi
  return
}

comparedirectory() {
  local result=0
  for i in `(ls -A "$1" && ls -A "$2") | sort | uniq`; do
    compare "$1/$i" "$2/$i" || result=1
  done
  return $result
}

comparesoftlink() {
  local dest1=`ls -l "$1" | awk '{ print $11 }'`
  local dest2=`ls -l "$2" | awk '{ print $11 }'`

  if [ "$dest1" == "$dest2" ]; then
    return 0
  else
    echo $"`date '+%H:%M:%S %m/%d/%y'`": "DIFFERENT LINK TARGETS $1 -> $dest1, $2 -> $dest2" >> /tmp/PriorityManager_IsRunning
    return 1
  fi
}

# compare a file, directory, or softlink
compare() {
  exists "$1" "$2"
  result=$?
  if [ "$result" == 2 ]; then
     return 0
  elif [ "$result" == 1 ]; then
     return 1
  fi

  local type1=$(gettype "$1")
  local type2=$(gettype "$2")

  if [ "$type1" == "$type2" ]; then
    case $type1 in
      file)
        if [ -f "$1" ] || [ -f "$2" ]; then
           comparefile "$1" "$2"
        fi
        ;;
      directory)
        if [ -d "$1" ] || [ -d "$2" ]; then
           comparedirectory "$1" "$2"
        fi
        ;;
      softlink)
        if [ -L "$1" ] || [ -L "$2" ]; then
           comparesoftlink "$1" "$2"
        fi
        ;;
      *)
        echo $"`date '+%H:%M:%S %m/%d/%y'`": "$1 OF UNKNOWN TYPE" >> /tmp/PriorityManager_IsRunning
        false
        ;;
    esac
  else
    echo $"`date '+%H:%M:%S %m/%d/%y'`": "TYPE MISMATCH: $type1 ($1) AND $type2 ($2)" >> /tmp/PriorityManager_IsRunning
    false
  fi

  return
}

start_log() {
   if [ "$LOG_STARTED" == "1" ]; then
      return
   fi
   LOG_STARTED=1
   rm -f /tmp/PriorityManager_IsRunning
   echo "" > /tmp/PriorityManager_LogStarted
   echo "PRIORITY MANAGER V1.8 BY BUYUKBANG" > /tmp/PriorityManager_IsRunning
   echo "FLAGS => R:RECORD M:MOUNT S:SWAP A:ACTION B:BUSYBOX C:CRON P:PLUGINS" >> /tmp/PriorityManager_IsRunning
}

start_emus() {
   for emu in `sed 's/^ *//;s/ *$//' /EMU/OpenXCAS/module.seq | grep ^[^#]` ; do
      daemon=`awk -F"=" '/^daemon/ { print $2 }' /EMU/OpenXCAS/$emu/openxcas.conf | sed 's/^ *//;s/ *$//'`
      if [ "$(ps | grep "/EMU/OpenXCAS/$emu/$daemon" | egrep -v grep |wc -l)" -lt 1  ]; then
         $nohup /EMU/OpenXCAS/$emu/$daemon > /dev/null &
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "/EMU/OpenXCAS/$emu/$daemon STARTED" >> /tmp/PriorityManager_IsRunning
      fi
   done
}

injectCode() {
   if [ "$(grep "### PRIORITY MANAGER START ###" /MMP/usr/bin/S.sh | wc -l)" -lt 1  ]; then
      mount -o remount,rw -t ext3 /dev/hda1 /MMP
      if [ -s /MMP/usr/bin/S.sh_pm_backup ]; then
         cp -f /MMP/usr/bin/S.sh_pm_backup /MMP/usr/bin/S.sh
      else
         cp -f /MMP/usr/bin/S.sh /MMP/usr/bin/S.sh_pm_backup
      fi
      if [ ! -s /MMP/usr/bin/S.sh_pm_backup ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MODIFYING S.sh FAILED" >> /tmp/PriorityManager_IsRunning
         sync
         return 1
      fi
      awk '{sub(/\/MMP\/usr\/bin\/CRTVCore &/,"\n### PRIORITY MANAGER START ###\nif [ -f /DISK2/etc/start.d/S1PriorityManager.sh ]; then\n  /DISK2/etc/start.d/S1PriorityManager.sh initJobs\nfi\n### PRIORITY MANAGER END ###\n\n&")}; 1' /MMP/usr/bin/S.sh_pm_backup > /MMP/usr/bin/S.sh
      if [ ! -s /MMP/usr/bin/S.sh ]; then
         cp -f /MMP/usr/bin/S.sh /MMP/usr/bin/S.sh_pm_backup
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MODIFYING S.sh FAILED" >> /tmp/PriorityManager_IsRunning
         sync
         return 1
      fi
      chmod 755 /MMP/usr/bin/S.sh /MMP/usr/bin/S.sh_pm_backup
      mount -o remount,ro -t ext3 /dev/hda1 /MMP
   fi
   sync
   return 0
}

initJobs() {
  if [ -f /DISK2/channel_list_switched ]; then
      cd  /DISK2
      tar -xvzf firstlist.tgz
      rm /DISK2/channel_list_switched
      cd /DISK2/etc/start.d
   fi

   if [ "$MOVE_PLUGINS" == 1 ] && [ "$TARGET_DEVICE" != "" ]; then
      DEV_PREFIX7=`echo $TARGET_DEVICE | awk '{print substr($1,1,7)}'`
      if [ "$DEV_PREFIX7" == "/dev/sd" ];then
         DEV_PREFIX=`echo $TARGET_DEVICE | awk '{print substr($1,1,8)}'`
         MOUNT_HOME="/DATA/usb1"
         [ "$DEV_PREFIX" = "/dev/sda" ] && MOUNT_HOME="/DATA/usb1"
         [ "$DEV_PREFIX" = "/dev/sdb" ] && MOUNT_HOME="/DATA/usb2"
         [ "$DEV_PREFIX" = "/dev/sdc" ] && MOUNT_HOME="/DATA/usb2"
         [ "$DEV_PREFIX" = "/dev/sdd" ] && MOUNT_HOME="/DATA/usb2"
         DEV_NAME=`echo $TARGET_DEVICE | awk -F/ '{print $3}'`
         MOUNT_POINT="$MOUNT_HOME/$DEV_NAME"
         FS_INFO=`fdisk -l | grep "^$DEVPATH"`
         FS_TYPE="none"
         [ -n "`echo $FS_INFO | grep Win95`" ] && FS_TYPE="none"
         [ -n "`echo $FS_INFO | grep NTFS`"  ] && FS_TYPE="ntfs"
         [ -n "`echo $FS_INFO | grep FAT`"   ] && FS_TYPE="vfat"
         [ -n "`echo $FS_INFO | grep Linux`" ] && FS_TYPE="ext3"
         case "$FS_TYPE" in
            ntfs)
               mkdir -p $MOUNT_POINT
               if [ -f "$UPNP_CHECK" ]; then 
                  ntfs-3g $DEVPATH $MOUNT_POINT -o defaults,locale=ko_KR.UTF-8
                  else
                  mount -t ntfs $DEVPATH $MOUNT_POINT -o ro,nls=utf8
               fi
               [ $? != 0 ] && rmdir $MOUNT_POINT
            ;;
            vfat)
               mkdir -p $MOUNT_POINT
               mount -t vfat $DEVPATH $MOUNT_POINT -o rw,noexec,nosuid,nodev,noatime,uid=0,utf8
               [ $? != 0 ] && rmdir $MOUNT_POINT
            ;;
            ext3)
               mkdir -p $MOUNT_POINT
               mount $DEVPATH $MOUNT_POINT
               [ $? != 0 ] && rmdir $MOUNT_POINT
            ;;
            none)
               case "$DEVPATH" in
                  "/dev/sda" |"/dev/sdb" |"/dev/sdc" |"/dev/sdd")
                  mkdir -p $MOUNT_POINT
                  mount -t auto $DEVPATH $MOUNT_POINT -o rw,noexec,nosuid,nodev,noatime,uid=0,utf8
                  [ $? != 0 ] && rmdir $MOUNT_POINT
               ;;
            esac
            ;;
         esac
         sync
      fi

      mount $TARGET_DEVICE /PLUGINS
      rm /EMU /USER
      ln -sf /PLUGINS /EMU
      ln -sf /PLUGINS /USER
   fi
}

move_plugins() {
   if [ "$MOVE_PLUGINS" == 1 ];then
      start_log

      if [ "$TARGET_DEVICE" == "" ];then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS FAILED: TARGET_DEVICE IS NOT DEFINED" >> /tmp/PriorityManager_IsRunning
         return
      fi

      if [ "$(mount | grep "on /PLUGINS type" | tail -1 | grep $TARGET_DEVICE | wc -l)" -gt 0  ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "PLUGINS ALREADY MOVED" >> /tmp/PriorityManager_IsRunning
         return
      fi

      if [ "$PLUGINS_BACKUP_PATH" == "" ];then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS FAILED: PLUGINS_BACKUP_PATH IS NOT DEFINED" >> /tmp/PriorityManager_IsRunning
         return
      fi
      
      mkdir $PLUGINS_BACKUP_PATH
      if [ ! -d $PLUGINS_BACKUP_PATH ];then        
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS FAILED: A VALID PLUGINS_BACKUP_PATH IS NOT DEFINED" >> /tmp/PriorityManager_IsRunning
         return
      fi

      SLEEP_COUNTER=0
      while [ "$MOUNTPATH" == "" ] && [ "$SLEEP_COUNTER" != "$TARGET_DEVICE_SECONDS" ]; do     	 
         MOUNTPATH=`mount | grep $TARGET_DEVICE | egrep -v "on /PLUGINS type" | head -n 1 | awk '{print $3}'`
         sleep 1
         let SLEEP_COUNTER=SLEEP_COUNTER+1
      done
      if [ "$MOUNTPATH" == "" ] || [ ! -d $MOUNTPATH ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS FAILED: $TARGET_DEVICE IS NOT MOUNTED" >> /tmp/PriorityManager_IsRunning
         return
      fi
     
      if [ "$(ls -l1a /PLUGINS/ | awk -- 'NR > 2' | egrep -v "$MOUNTPATH" | wc -l)" -gt 0  ]; then
         BACKUP_DATE=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}'`
         if [ -d $PLUGINS_BACKUP_PATH/PLUGINS_$BACKUP_DATE ];then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS FAILED: PLUGINS_$BACKUP_DATE ALREADY EXISTS" >> /tmp/PriorityManager_IsRunning
            return
         fi
         
         mkdir $PLUGINS_BACKUP_PATH/PLUGINS_$BACKUP_DATE
         cp -rf /PLUGINS/* $PLUGINS_BACKUP_PATH/PLUGINS_$BACKUP_DATE/
         if [ ! -d $PLUGINS_BACKUP_PATH/PLUGINS_$BACKUP_DATE ];then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS FAILED: CANNOT WRITE TO BACKUP PATH" >> /tmp/PriorityManager_IsRunning
            return
         fi
         
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS TO $MOUNTPATH" >> /tmp/PriorityManager_IsRunning
         for directory in `ls /PLUGINS/` ; do
            if [ -d /PLUGINS/$directory ] && [ ! -L /PLUGINS/$directory ] && [ -f /PLUGINS/$directory/sh/install.sh ] && [ -f /PLUGINS/$directory/sh/delete.sh ]; then
               cp -rf /PLUGINS/$directory $MOUNTPATH/
               compare /PLUGINS/$directory $MOUNTPATH/$directory
               if [ $? -eq 0 ]; then
                  rm -rf /PLUGINS/$directory
                  if [ ! -e /PLUGINS/$directory ]; then
                     ln -sf $MOUNTPATH/$directory /PLUGINS/$directory
                     if [ ! -L /PLUGINS/$directory ]; then
                        echo $"`date '+%H:%M:%S %m/%d/%y'`": "SYMLINKS TO $MOUNTPATH/$directory CANNOT BE CREATED" >> /tmp/PriorityManager_IsRunning
                     fi
                  else
                     echo $"`date '+%H:%M:%S %m/%d/%y'`": "/PLUGINS/$directory CANNOT BE DELETED" >> /tmp/PriorityManager_IsRunning
                  fi
               else
                  echo $"`date '+%H:%M:%S %m/%d/%y'`": "$MOUNTPATH/$directory CANNOT BE CREATED" >> /tmp/PriorityManager_IsRunning
               fi
            fi
         done
         
         mv -f /PLUGINS/home $MOUNTPATH/
         mv -f /PLUGINS/*.ttf /PLUGINS/*.TTF /PLUGINS/*.Ttf /PLUGINS/*.tTf /PLUGINS/*.ttF /PLUGINS/*.TTf /PLUGINS/*.tTF /PLUGINS/*.TtF $MOUNTPATH/
         mv -f /PLUGINS/plugins.conf $MOUNTPATH/
      fi

      echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOUNTING $MOUNTPATH TO /PLUGINS" >> /tmp/PriorityManager_IsRunning
      sync
      umount -lf /PLUGINS  	  
      mount $TARGET_DEVICE /PLUGINS
      if [ "$(mount | grep "on /PLUGINS type" | tail -1 | grep $TARGET_DEVICE | wc -l)" -lt 1  ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOUNTING $TARGET_DEVICE TO /PLUGINS FAILED" >> /tmp/PriorityManager_IsRunning
         return
      fi
      
      injectCode
      if [ ! $? -eq 0 ]; then
         return
      fi
      
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "RECREATING SYMLINKS FOR /USER /EMU" >> /tmp/PriorityManager_IsRunning
      rm -f /USER
      rm -f /EMU
      ln -sf $MOUNTPATH /USER
      ln -sf $MOUNTPATH /EMU
      if [ ! -L /USER ] || [ ! -L /EMU ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "RECREATING SYMLINKS FAILED, REBOOT IS RECOMMENDED TO COMPLETE THE PROCESS" >> /tmp/PriorityManager_IsRunning
      fi

      echo $"`date '+%H:%M:%S %m/%d/%y'`": "PLUGINS MOVED" >> /tmp/PriorityManager_IsRunning
      mount | grep "on /PLUGINS type" | tail -1 >> /tmp/PriorityManager_IsRunning
      echo "" >> /tmp/PriorityManager_IsRunning
      sync
   fi
}

move_back_plugins() {
   if [ "$MOVE_PLUGINS" == 0 ] && [ ! "$TARGET_DEVICE" == "" ] && [ "$(mount | grep "on /PLUGINS type" | tail -n 1 | grep "/dev/hda2" | wc -l)" -lt 1 ]; then
      start_log

      SLEEP_COUNTER=0
      while [ "$MOUNTPATH" == "" ] && [ "$SLEEP_COUNTER" != "$TARGET_DEVICE_SECONDS" ]; do
         MOUNTPATH=`mount | grep $TARGET_DEVICE | egrep -v "on /PLUGINS type" | head -n 1 | awk '{print $3}'`
         sleep 1
         let SLEEP_COUNTER=SLEEP_COUNTER+1
      done
      if [ "$MOUNTPATH" == "" ] || [ ! -d $MOUNTPATH ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "ERROR: $TARGET_DEVICE IS NOT MOUNTED" >> /tmp/PriorityManager_IsRunning
         return
      fi

      MOVED_PLUGIN_FOUND=0
      for directory in `ls $MOUNTPATH/` ; do
         if [ -d $MOUNTPATH/$directory ] && [ ! -L $MOUNTPATH/$directory ] && [ -f $MOUNTPATH/$directory/sh/install.sh ] && [ -f $MOUNTPATH/$directory/sh/delete.sh ]; then
           MOVED_PLUGIN_FOUND=1
           break
         fi
      done
      if [ "$MOVED_PLUGIN_FOUND" == "0" ]; then
         return
      fi

      echo $"`date '+%H:%M:%S %m/%d/%y'`": "REMOVING SYMLINKS CREATED IN /dev/hda2" >> /tmp/PriorityManager_IsRunning
      HDA2=/tmp/pm_tmp_$$
      mkdir $HDA2
      mount -t ext3 /dev/hda2 $HDA2
      for slink in `ls -l1a $HDA2/ | awk -- 'NR > 2' | grep "$MOUNTPATH"| awk '{ print $7 }'` ; do
         if [ -L $HDA2/$slink ]; then
            rm -f $HDA2/$slink
         fi
      done

       echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOVING PLUGINS FROM $MOUNTPATH TO /dev/hda2" >> /tmp/PriorityManager_IsRunning
       for directory in `ls $MOUNTPATH/` ; do
          if [ -d $MOUNTPATH/$directory ] && [ ! -L $HDA2/$directory ] && [ -f $MOUNTPATH/$directory/sh/install.sh ] && [ -f $MOUNTPATH/$directory/sh/delete.sh ]; then
             cp -rf $MOUNTPATH/$directory $HDA2/
             compare /PLUGINS/$directory $MOUNTPATH/$directory
             if [ $? -eq 0 ] && [ -d $HDA2/$directory ] && [ ! -L $HDA2/$directory ]; then
                rm -rf $MOUNTPATH/$directory
                if [ -e $MOUNTPATH/$directory ]; then
                   echo $"`date '+%H:%M:%S %m/%d/%y'`": "$MOUNTPATH/$directory CANNOT BE DELETED" >> /tmp/PriorityManager_IsRunning
                fi
             else
                echo $"`date '+%H:%M:%S %m/%d/%y'`": "$HDA2/$directory CANNOT BE CREATED" >> /tmp/PriorityManager_IsRunning
             fi
          fi
       done

      mv -f $MOUNTPATH/home $HDA2/
      mv -f $MOUNTPATH/*.ttf $MOUNTPATH/*.TTF $MOUNTPATH/*.Ttf $MOUNTPATH/*.tTf $MOUNTPATH/*.ttF $MOUNTPATH/*.TTf $MOUNTPATH/*.tTF $MOUNTPATH/*.TtF $HDA2/
      mv -f $MOUNTPATH/plugins.conf $HDA2/
      
      sync
      umount -lf $HDA2 
      
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOUNTING /dev/hda2 TO /PLUGINS" >> /tmp/PriorityManager_IsRunning
      umount -lf /PLUGINS
      mount -t ext3 /dev/hda2 /PLUGINS
      if [ "$(mount | grep "on /PLUGINS type" | tail -1 | grep /dev/hda2 | wc -l)" -lt 1  ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "MOUNTING /dev/hda2 TO /PLUGINS FAILED, REBOOT IS NEEDED" >> /tmp/PriorityManager_IsRunning
      fi

      echo $"`date '+%H:%M:%S %m/%d/%y'`": "RECREATING SYMLINKS FOR /USER /EMU" >> /tmp/PriorityManager_IsRunning
      rm -f /USER
      rm -f /EMU
      ln -s /PLUGINS /USER
      ln -s /PLUGINS /EMU
      if [ ! -L /USER ] || [ ! -L /EMU ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "RECREATING SYMLINKS FAILED, REBOOT IS IS NEEDED" >> /tmp/PriorityManager_IsRunning
      fi

      echo $"`date '+%H:%M:%S %m/%d/%y'`": "PLUGINS MOVED BACK" >> /tmp/PriorityManager_IsRunning
      mount | grep "on /PLUGINS type" | tail -1 >> /tmp/PriorityManager_IsRunning
      echo "" >> /tmp/PriorityManager_IsRunning
      sync
   fi
}


start() {
   if [ ! -d /PLUGINS/PriorityManager ] || [ -L /PLUGINS/PriorityManager ]; then
      start_log
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "/PLUGINS/PriorityManager DOES NOT EXIST, WAITING FOR MOUNT..." >> /tmp/PriorityManager_IsRunning
      while [ ! -d /PLUGINS/PriorityManager ]; do
         sleep 10
      done
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "PATH /PLUGINS/PriorityManager IS MOUNTED" >> /tmp/PriorityManager_IsRunning
      start_emus
   fi

   if [ "$VERBOSE_LOG" == 1 ]; then
      exec 1>/Download/PriorityManager_Verbose_Log 2>/Download/PriorityManager_Verbose_Log
      set -x
   fi

   move_back_plugins
   move_plugins

	 if [ "$VERBOSE_LOG" == 1 ]; then
      set +x
      exec 1>/dev/null 2>/dev/null
   fi
   if [ "$LOG_STARTED" == "0" ]; then
      rm -f /tmp/PriorityManager_LogStarted
   fi
   $nohup /bin/sh /PLUGINS/PriorityManager/PriorityManager.sh > /dev/null &
   echo "Priority Manager Started"
   sync
}

stop() {
   sync
   kill -9 `ps | egrep "PriorityManager.sh|crond|reload_tv.sh|exit.scr" | egrep -v S1PriorityManager.sh | egrep -v grep | awk '{print $1}'`
   rm -f /tmp/PriorityManager_IsRunning /tmp/PriorityManager_Last_Menu /tmp/PriorityManager_Process_List /tmp/PriorityManager_CheckPath /Download/PriorityManager_Verbose_Log /tmp/PriorityManager_LogStarted /tmp/PriorityManager_Reload_TV /tmp/PriorityManager_Reload_TV2 /tmp/PriorityManager_Reload_TV_Running
   snice STOP ir_control DStar SDecoderServer file_control CRTVCore CRTVSetup cheops_module JIPC_Server telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
   snice ir_control SDecoderServer file_control CRTVCore CRTVSetup cheops_module JIPC_Server telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc 0
   snice DStar -5

   if [ "$SWAPPER" == 1 ]; then
      sync
      swapoff $SWAPDEVICE/swapfile &
   fi

   if [ "$CIF_MOUNT" != 0 ] || [ "$NFS_MOUNT" != 0 ]; then
      for MOUNT_POINT in `mount | grep $REMOTE_IP | awk -F" on " '{print $2}' | awk -F" type " '{print $1}'`; do
         umount -lf $MOUNT_POINT &
      done
   fi
   
   echo "Priority Manager Stopped"
}

restart() {
   stop
   start
}

case "$1" in
  start)
   start
  ;;
  stop)
   stop
  ;;
  restart|reload)
   restart
  ;;
  initJobs)
   initJobs
  ;;
  injectCode)
   injectCode
  ;;
  *)
 echo $"Usage: $0 {start|stop|restart}"
 exit 1
esac

exit 0
