#!/bin/sh
# 
# PRIORITY MANAGER V1.8 BY BUYUKBANG
#
#########################################################################################
#
# PLEASE READ FOLLOWING FILE FOR MORE INFORMATION: /PLUGINS/PriorityManager/readme.txt
#
#########################################################################################

if [ -f /DISK2/etc/PriorityManagerSettings.txt ]; then
   dos2unix /DISK2/etc/PriorityManagerSettings.txt
   . /DISK2/etc/PriorityManagerSettings.txt
fi

gettype() {
  if [ -L "$1" ]; then
    echo "softlink"
  elif [ -f "$1" ]; then
    echo "file"
  elif [ -d "$1" ]; then
    echo "directory"
  else
    echo "unknown"
  fi
}

exists() {
   a=0
   b=0
   if [ -e "$1" -o -L "$1" ]; then
      a=1
   fi
   if [ -e "$2" -o -L "$1" ]; then
      b=1
   fi

   if [ "$a" == "1" ] && [ "$b" == "0" ]; then
      return 1
   elif [ "$a" == "0" ] && [ "$b" == "1" ]; then
      return 1
   elif [ "$a" == "1" ] && [ "$b" == "1" ]; then
      return 0
   else
     return 2
   fi
}

comparefile() {
  cmp -s "$1" "$2"
  return
}

comparedirectory() {
  local result=0
  for i in `(ls -A "$1" && ls -A "$2") | sort | uniq`; do
    compare "$1/$i" "$2/$i" || result=1
  done
  return $result
}

comparesoftlink() {
  local dest1=`ls -l "$1" | awk '{ print $11 }'`
  local dest2=`ls -l "$2" | awk '{ print $11 }'`

  if [ "$dest1" == "$dest2" ]; then
    return 0
  else
    return 1
  fi
}

# compare a file, directory, or softlink
compare() {
  exists "$1" "$2"
  result=$?
  if [ "$result" == 2 ]; then
     return 0
  elif [ "$result" == 1 ]; then
     return 1
  fi

  local type1=$(gettype "$1")
  local type2=$(gettype "$2")

  if [ "$type1" == "$type2" ]; then
    case $type1 in
      file)
        if [ -f "$1" ] || [ -f "$2" ]; then
           comparefile "$1" "$2"
        fi
        ;;
      directory)
        if [ -d "$1" ] || [ -d "$2" ]; then
           comparedirectory "$1" "$2"
        fi
        ;;
      softlink)
        if [ -L "$1" ] || [ -L "$2" ]; then
           comparesoftlink "$1" "$2"
        fi
        ;;
      *)
        false
        ;;
    esac
  else
    false
  fi

  return
}


move_back_plugins() {
   if [ "$MOVE_PLUGINS" == 1 ] && [ ! "$TARGET_DEVICE" == "" ] && [ "$(mount | grep "on /PLUGINS type" | tail -1 | grep $TARGET_DEVICE | wc -l)" -gt 0  ]; then
      MOUNTPATH=`mount | grep $TARGET_DEVICE | egrep -v "on /PLUGINS type" | head -n 1 | awk '{print $3}'`
      if [ "$MOUNTPATH" == "" ] || [ ! -d $MOUNTPATH ]; then
         return
      fi

      MOVED_PLUGIN_FOUND=0
      for directory in `ls $MOUNTPATH/` ; do
         if [ -d $MOUNTPATH/$directory ] && [ ! -L $MOUNTPATH/$directory ] && [ -f $MOUNTPATH/$directory/sh/install.sh ] && [ -f $MOUNTPATH/$directory/sh/delete.sh ]; then
           MOVED_PLUGIN_FOUND=1
           break
         fi
      done
      if [ "$MOVED_PLUGIN_FOUND" == "0" ]; then
         return
      fi
      
      HDA2=/tmp/pm_tmp_$$
      mkdir $HDA2
      mount -t ext3 /dev/hda2 $HDA2  
      for slink in `ls -l1a $HDA2/ | awk -- 'NR > 2' | grep "$MOUNTPATH"| awk '{ print $7 }'` ; do
         if [ -L $HDA2/$slink ]; then
            rm -f $HDA2/$slink
         fi
      done

      for directory in `ls $MOUNTPATH/` ; do
         if [ -d $MOUNTPATH/$directory ] && [ ! -L $HDA2/$directory ] && [ -f $MOUNTPATH/$directory/sh/install.sh ] && [ -f $MOUNTPATH/$directory/sh/delete.sh ]; then
            cp -rf $MOUNTPATH/$directory $HDA2/
            compare /PLUGINS/$directory $MOUNTPATH/$directory
            if [ $? -eq 0 ]; then
               rm -rf $MOUNTPATH/$directory
            fi
          fi
      done

      mv -f $MOUNTPATH/home $HDA2/
      mv -f $MOUNTPATH/*.ttf $MOUNTPATH/*.TTF $MOUNTPATH/*.Ttf $MOUNTPATH/*.tTf $MOUNTPATH/*.ttF $MOUNTPATH/*.TTf $MOUNTPATH/*.tTF $MOUNTPATH/*.TtF $HDA2/
      mv -f $MOUNTPATH/plugins.conf $HDA2/
       
      sync
      umount -lf $HDA2 
      umount -lf /PLUGINS
      mount -t ext3 /dev/hda2 /PLUGINS
      
      rm -f /USER
      rm -f /EMU
      ln -s /PLUGINS /USER
      ln -s /PLUGINS /EMU
      sync
   fi
}


removeCode() {
   if [ "$(grep "### PRIORITY MANAGER START ###" /MMP/usr/bin/S.sh | wc -l)" -gt 0  ] &&  [ -s /MMP/usr/bin/S.sh_pm_backup ]; then
      mount -o remount,rw -t ext3 /dev/hda1 /MMP
      cp -f /MMP/usr/bin/S.sh_pm_backup /MMP/usr/bin/S.sh
      rm -f /MMP/usr/bin/S.sh_pm_backup
      chmod 755 /MMP/usr/bin/S.sh
      mount -o remount,ro -t ext3 /dev/hda1 /MMP
   fi
}


/DISK2/etc/start.d/S1PriorityManager.sh stop
rm -f /DISK2/etc/start.d/S1PriorityManager.sh /DISK2/etc/PriorityManagerSettings.txt /DISK2/channel_list_switched /DISK2/etc/standby.sh /DISK2/etc/wakeup.sh /tmp/PriorityManagerMenuData /tmp/PriorityManagerMenuReady /tmp/PriorityManager_Sleep
if [ -f /DISK2/etc/standby.sh_backup ]; then
	 mv /DISK2/etc/standby.sh_backup /DISK2/etc/standby.sh
	 chmod 755 /DISK2/etc/standby.sh 
fi
if [ -f /DISK2/etc/wakeup.sh_backup ]; then
	 mv /DISK2/etc/wakeup.sh_backup /DISK2/etc/wakeup.sh
   chmod 755 /DISK2/etc/wakeup.sh  
fi
move_back_plugins
removeCode
kill -9 `ps | grep PriorityManager | egrep -v grep | awk '{print $1}'` 
rm -rf /PLUGINS/PriorityManager

echo "Priority Manager Deactivated Successfully"

sync

