#!/bin/sh
# 
# PRIORITY MANAGER V1.8 BY BUYUKBANG
#
#########################################################################################
#
# PLEASE READ FOLLOWING FILE FOR MORE INFORMATION: /PLUGINS/PriorityManager/readme.txt
#
#########################################################################################

if [ -f /DISK2/etc/PriorityManagerSettings.txt ]; then
   dos2unix /DISK2/etc/PriorityManagerSettings.txt
   . /DISK2/etc/PriorityManagerSettings.txt
else
   exit
fi

nohup="/PLUGINS/PriorityManager/busybox nohup"
top="/PLUGINS/PriorityManager/busybox top"

gettype() {
  if [ -L "$1" ]; then
    echo "softlink"
  elif [ -f "$1" ]; then
    echo "file"
  elif [ -d "$1" ]; then
    echo "directory"
  else
    echo "unknown"
  fi
}

exists() {
   a=0
   b=0
   if [ -e "$1" -o -L "$1" ]; then
      a=1
   fi
   if [ -e "$2" -o -L "$1" ]; then
      b=1
   fi

   if [ "$a" == "1" ] && [ "$b" == "0" ]; then
      return 1
   elif [ "$a" == "0" ] && [ "$b" == "1" ]; then
      return 1
   elif [ "$a" == "1" ] && [ "$b" == "1" ]; then
      return 0
   else
     return 2
   fi
}

comparefile() {
  cmp -s "$1" "$2"
  return
}

comparedirectory() {
  local result=0
  for i in `(ls -A "$1" && ls -A "$2") | sort | uniq`; do
    compare "$1/$i" "$2/$i" || result=1
  done
  return $result
}

comparesoftlink() {
  local dest1=`ls -l "$1" | awk '{ print $11 }'`
  local dest2=`ls -l "$2" | awk '{ print $11 }'`

  if [ "$dest1" == "$dest2" ]; then
    return 0
  else
    return 1
  fi
}

# compare a file, directory, or softlink
compare() {
  exists "$1" "$2"
  result=$?
  if [ "$result" == 2 ]; then
     return 0
  elif [ "$result" == 1 ]; then
     return 1
  fi

  local type1=$(gettype "$1")
  local type2=$(gettype "$2")

  if [ "$type1" == "$type2" ]; then
    case $type1 in
      file)
        if [ -f "$1" ] || [ -f "$2" ]; then
           comparefile "$1" "$2"
        fi
        ;;
      directory)
        if [ -d "$1" ] || [ -d "$2" ]; then
           comparedirectory "$1" "$2"
        fi
        ;;
      softlink)
        if [ -L "$1" ] || [ -L "$2" ]; then
           comparesoftlink "$1" "$2"
        fi
        ;;
      *)
        false
        ;;
    esac
  else
    false
  fi

  return
}


move_back_plugins() {
   if [ "$MOVE_PLUGINS" == 1 ] && [ ! "$TARGET_DEVICE" == "" ] && [ "$(mount | grep "on /PLUGINS type" | tail -1 | grep $TARGET_DEVICE | wc -l)" -gt 0  ]; then
      MOUNTPATH=`mount | grep $TARGET_DEVICE | egrep -v "on /PLUGINS type" | head -n 1 | awk '{print $3}'`
      if [ "$MOUNTPATH" == "" ] || [ ! -d $MOUNTPATH ]; then
         return
      fi

      MOVED_PLUGIN_FOUND=0
      for directory in `ls $MOUNTPATH/` ; do
         if [ -d $MOUNTPATH/$directory ] && [ ! -L $MOUNTPATH/$directory ] && [ -f $MOUNTPATH/$directory/sh/install.sh ] && [ -f $MOUNTPATH/$directory/sh/delete.sh ]; then
           MOVED_PLUGIN_FOUND=1
           break
         fi
      done
      if [ "$MOVED_PLUGIN_FOUND" == "0" ]; then
         return
      fi
      
      HDA2=/tmp/pm_tmp_$$
      mkdir $HDA2
      mount -t ext3 /dev/hda2 $HDA2  
      for slink in `ls -l1a $HDA2/ | awk -- 'NR > 2' | grep "$MOUNTPATH"| awk '{ print $7 }'` ; do
         if [ -L $HDA2/$slink ]; then
            rm -f $HDA2/$slink
         fi
      done

      for directory in `ls $MOUNTPATH/` ; do
         if [ -d $MOUNTPATH/$directory ] && [ ! -L $HDA2/$directory ] && [ -f $MOUNTPATH/$directory/sh/install.sh ] && [ -f $MOUNTPATH/$directory/sh/delete.sh ]; then
            cp -rf $MOUNTPATH/$directory $HDA2/
            compare /PLUGINS/$directory $MOUNTPATH/$directory
            if [ $? -eq 0 ]; then
               rm -rf $MOUNTPATH/$directory
            fi
          fi
      done

      mv -f $MOUNTPATH/home $HDA2/
      mv -f $MOUNTPATH/*.ttf $MOUNTPATH/*.TTF $MOUNTPATH/*.Ttf $MOUNTPATH/*.tTf $MOUNTPATH/*.ttF $MOUNTPATH/*.TTf $MOUNTPATH/*.tTF $MOUNTPATH/*.TtF $HDA2/
      mv -f $MOUNTPATH/plugins.conf $HDA2/
       
      sync
      umount -lf $HDA2 
      umount -lf /PLUGINS
      mount -t ext3 /dev/hda2 /PLUGINS
      
      rm -f /USER
      rm -f /EMU
      ln -s /PLUGINS /USER
      ln -s /PLUGINS /EMU
      sync
   fi
}


removeCode() {
   if [ "$(grep "### PRIORITY MANAGER START ###" /MMP/usr/bin/S.sh | wc -l)" -gt 0  ] &&  [ -s /MMP/usr/bin/S.sh_pm_backup ]; then
      mount -o remount,rw -t ext3 /dev/hda1 /MMP
      cp -f /MMP/usr/bin/S.sh_pm_backup /MMP/usr/bin/S.sh
      rm -f /MMP/usr/bin/S.sh_pm_backup
      chmod 755 /MMP/usr/bin/S.sh
      mount -o remount,ro -t ext3 /dev/hda1 /MMP
   fi
}

take_backup() {
      CURRENT_DATE=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}'`
      mkdir $BACKUP_PATH
      mkdir $BACKUP_PATH/$CURRENT_DATE
      dircount=0
      
      if [ "$COMPRESSED_BACKUP" == 0 ]; then
         cp -rf /DISK2 $BACKUP_PATH/$CURRENT_DATE/DISK2
         sync
         if [ ! -d $BACKUP_PATH/$CURRENT_DATE/DISK2 ];then
            echo "BACKUP OF /DISK2 FAILED" > /tmp/PriorityManagerMenuData
            return
         fi
         cp -rf /PLUGINS $BACKUP_PATH/$CURRENT_DATE/PLUGINS
         sync
         if [ ! -d $BACKUP_PATH/$CURRENT_DATE/PLUGINS ];then
            echo "BACKUP OF /PLUGINS FAILED" > /tmp/PriorityManagerMenuData
            return
         fi
      else
         rm -f $BACKUP_PATH/$CURRENT_DATE/DISK2.tar.gz
         tar -czf $BACKUP_PATH/$CURRENT_DATE/DISK2.tar.gz /DISK2
         sync
         if [ ! -f $BACKUP_PATH/$CURRENT_DATE/DISK2.tar.gz ];then
            echo "BACKUP OF /DISK2 FAILED" > /tmp/PriorityManagerMenuData
            return
         fi
         rm -f $BACKUP_PATH/$CURRENT_DATE/PLUGINS.tar.gz
         tar -czf $BACKUP_PATH/$CURRENT_DATE/PLUGINS.tar.gz /PLUGINS
         sync
         if [ ! -f $BACKUP_PATH/$CURRENT_DATE/PLUGINS.tar.gz ];then
            echo "BACKUP OF /PLUGINS FAILED" > /tmp/PriorityManagerMenuData
            return
         fi
      fi

      for dir in `ls -lr1 $BACKUP_PATH/ | awk '{ print $7 }'` ; do
         if [ -d $BACKUP_PATH/$dir ]; then
            if [ $dircount -ge $NUMBER_OF_BACKUPS ];then 
               rm -fr $BACKUP_PATH/$dir
            fi
            let dircount=dircount+1
         fi
      done

      NEXT_BACKUP_DATE=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime()+'$BACKUP_FREQUENCY'*86400)}'`
      echo $NEXT_BACKUP_DATE > /PLUGINS/PriorityManager/next_backup_date 
      echo "BACKUP COMPLETED" > /tmp/PriorityManagerMenuData
      sync
}


restore() {
   RESTORE_FOLDER=$BACKUP_PATH/`ls -1a $BACKUP_PATH/ | tail -1`
   if [ -f $RESTORE_FOLDER/PLUGINS.tar.gz ]; then
      cd / 
      tar -xzf $RESTORE_FOLDER/PLUGINS.tar.gz
      tar -xzf $RESTORE_FOLDER/DISK2.tar.gz
      cd /PLUGINS/PriorityManager/
      if [ $? -eq 0 ]; then
         echo "RESTORE COMPLETED" > /tmp/PriorityManagerMenuData
      else
         echo "EXTRACTING BACKUP ARCHIVE FAILED" > /tmp/PriorityManagerMenuData
      fi
   else
     cp -rf $RESTORE_FOLDER/PLUGINS/* /PLUGINS/
     cp -rf $RESTORE_FOLDER/DISK2/* /DISK2/
     echo "RESTORE COMPLETED" > /tmp/PriorityManagerMenuData
   fi
}


activateDefault() {
   if [ ! -f /DISK2/channel_list_switched ]; then
      echo "DEFAULT CHANNEL LIST IS ALREADY ACTIVATED" > /tmp/PriorityManagerMenuData
      return
   fi
   
   cd  /DISK2

   tar -xvzf firstlist.tgz
   if [ ! $? -eq 0 ]; then
      tar -xvzf secondlist.tgz
      cd /PLUGINS/PriorityManager 
      echo "AN ERROR OCCURED WHILE REPLACING CHANNEL LIST" > /tmp/PriorityManagerMenuData
      return
   fi

   rm  /DISK2/channel_list_switched
   echo 1 > /tmp/PriorityManager_Reload_TV2
   echo "DEFAULT CHANNEL LIST IS ACTIVATED, RESTARTING TV APPLICATION..." > /tmp/PriorityManagerMenuData
   cd /PLUGINS/PriorityManager 
   sync
}


activateHidden() {
   if [ -f /DISK2/channel_list_switched ]; then
      echo "HIDDEN CHANNEL LIST IS ALREADY ACTIVATED" > /tmp/PriorityManagerMenuData
      return
   fi
   
   cd  /DISK2
   
   TAROPTIONS="selene.conf"
   [ -f /DISK2/DVBS.dat ]         && TAROPTIONS=$TAROPTIONS" DVBS.dat"
   [ -f /DISK2/DVBTa.dat ]        && TAROPTIONS=$TAROPTIONS" DVBTa.dat"
   [ -f /DISK2/all_channel.dat ]  && TAROPTIONS=$TAROPTIONS" all_channel.dat"
   [ -f /DISK2/antenna_list.dat ] && TAROPTIONS=$TAROPTIONS" antenna_list.dat"
   [ -f /DISK2/country.dat ]      && TAROPTIONS=$TAROPTIONS" country.dat"
   [ -f /DISK2/genre.dat ]        && TAROPTIONS=$TAROPTIONS" genre.dat"
   [ -f /DISK2/http_streams.txt ] && TAROPTIONS=$TAROPTIONS" http_streams.txt"
   
   tar -cvzf firstlist.tgz $TAROPTIONS

   if [ ! $? -eq 0 ] || [ ! -s /DISK2/firstlist.tgz ]; then
      cd /PLUGINS/PriorityManager 
      echo "AN ERROR OCCURED WHILE SAVING DEFAULT CHANNEL LIST" > /tmp/PriorityManagerMenuData
      return
   fi

   tar -xvzf secondlist.tgz
   if [ ! $? -eq 0 ]; then
      tar -xvzf firstlist.tgz
      cd /PLUGINS/PriorityManager 
      echo "AN ERROR OCCURED WHILE REPLACING CHANNEL LIST" > /tmp/PriorityManagerMenuData
      return
   fi

   /bin/sh /DISK2/etc/start.d/S1PriorityManager.sh injectCode
   if [ $? -eq 0 ]; then
      echo 1 > /DISK2/channel_list_switched
      echo 1 > /tmp/PriorityManager_Reload_TV2
      echo "HIDDEN CHANNEL LIST IS ACTIVATED, RESTARTING TV APPLICATION..." > /tmp/PriorityManagerMenuData
      sync
   else
      tar -xvzf firstlist.tgz
      echo "MODIFYING S.sh FAILED" > /tmp/PriorityManagerMenuData
   fi  
   
   cd /PLUGINS/PriorityManager 
}


saveHidden() {
   cd  /DISK2
   TAROPTIONS="selene.conf"
   [ -f /DISK2/DVBS.dat ]         && TAROPTIONS=$TAROPTIONS" DVBS.dat"
   [ -f /DISK2/DVBTa.dat ]        && TAROPTIONS=$TAROPTIONS" DVBTa.dat"
   [ -f /DISK2/all_channel.dat ]  && TAROPTIONS=$TAROPTIONS" all_channel.dat"
   [ -f /DISK2/antenna_list.dat ] && TAROPTIONS=$TAROPTIONS" antenna_list.dat"
   [ -f /DISK2/country.dat ]      && TAROPTIONS=$TAROPTIONS" country.dat"
   [ -f /DISK2/genre.dat ]        && TAROPTIONS=$TAROPTIONS" genre.dat"
   [ -f /DISK2/http_streams.txt ] && TAROPTIONS=$TAROPTIONS" http_streams.txt"
   
   tar -cvzf secondlist.tgz $TAROPTIONS

   if [ ! $? -eq 0 ] || [ ! -s /DISK2/secondlist.tgz ]; then
      cd /PLUGINS/PriorityManager
      echo "AN ERROR OCCURED WHILE SAVING CHANNEL LIST" > /tmp/PriorityManagerMenuData
      return
   fi
   
   cd /PLUGINS/PriorityManager
   echo "CURRENT CHANNEL LIST IS SAVED AS HIDDEN CHANNEL LIST" > /tmp/PriorityManagerMenuData
}


rm -f /tmp/PriorityManagerMenuData
rm -f /tmp/PriorityManagerMenuReady

case $1 in
   1 ) # Show Log
      if [ -s /tmp/PriorityManager_IsRunning ]; then
         cat /tmp/PriorityManager_IsRunning > /tmp/PriorityManagerMenuData
      else
         echo "LOG FILE NOT FOUND, PLEASE ACTIVATE PRIORITY MANAGER FIRST" > /tmp/PriorityManagerMenuData
      fi
   ;;


   2 ) # Restart
      if [ -f /DISK2/etc/start.d/S1PriorityManager.sh ]; then
         /bin/sh /DISK2/etc/start.d/S1PriorityManager.sh restart &
         sleep 5
         echo "PRIORITY MANAGER RESTARTED SUCCESSFULLY" > /tmp/PriorityManagerMenuData
      else
         echo "PRIORITY MANAGER IS NOT ACTIVE, PLEASE ACTIVATE IT FIRST" > /tmp/PriorityManagerMenuData
      fi
   ;;


   3 ) # Activate / Reactivate
      if [ -f /DISK2/etc/start.d/S1PriorityManager.sh ]; then
         /DISK2/etc/start.d/S1PriorityManager.sh stop
         rm /DISK2/etc/start.d/S1PriorityManager.sh
      fi
      
      cp /PLUGINS/PriorityManager/S1PriorityManager.sh /DISK2/etc/start.d/S1PriorityManager.sh
      chmod 755 /DISK2/etc/start.d/S1PriorityManager.sh
      
      if [ -f /DISK2/etc/standby.sh ]; then
         if [ "$(grep PriorityManager /DISK2/etc/standby.sh |wc -l)" -lt 1 ]; then
            if [ "$(cmp /PLUGINS/PriorityManager/standby.sh /DISK2/etc/standby.sh  | wc -l)" -gt 0 ]; then
               mv /DISK2/etc/standby.sh /DISK2/etc/standby.sh_backup
            fi
         fi
      fi
      cp /PLUGINS/PriorityManager/standby.sh /DISK2/etc/standby.sh 
      chmod 755 /DISK2/etc/standby.sh 
      
      if [ -f /DISK2/etc/wakeup.sh ]; then
      	if [ "$(grep PriorityManager /DISK2/etc/wakeup.sh |wc -l)" -lt 1 ]; then
           if [ "$(cmp /PLUGINS/PriorityManager/wakeup.sh /DISK2/etc/wakeup.sh  | wc -l)" -gt 0 ]; then
              mv /DISK2/etc/wakeup.sh /DISK2/etc/wakeup.sh_backup
           fi
        fi
      fi
      cp /PLUGINS/PriorityManager/wakeup.sh /DISK2/etc/wakeup.sh 
      chmod 755 /DISK2/etc/wakeup.sh 
      
      /bin/sh /DISK2/etc/start.d/S1PriorityManager.sh start &
      sleep 5
      echo "PRIORITY MANAGER ACTIVATED SUCCESSFULLY" > /tmp/PriorityManagerMenuData
      sync
   ;;


   4 ) # Deactivate
      /bin/sh /DISK2/etc/start.d/S1PriorityManager.sh stop
      rm /DISK2/etc/start.d/S1PriorityManager.sh /DISK2/etc/standby.sh /DISK2/etc/wakeup.sh
      kill -9 `ps | egrep "PriorityManager.sh|crond" | egrep -v grep | awk '{print $1}'`
      move_back_plugins
      removeCode
      echo "PRIORITY MANAGER DEACTIVATED SUCCESSFULLY" > /tmp/PriorityManagerMenuData
      sync
   ;;


   5 ) # Movie & Browser Mode
      if [ -f /DISK2/etc/start.d/S1PriorityManager.sh ]; then
         if [ "$MODE" != "SERVER" ]; then
            chmod 755 /tmp/kill_EMUs.sh; /tmp/kill_EMUs.sh
            killall -9 CRTVSetup
            killall -9 CRTVCore
            echo 1 > /tmp/PriorityManager_Reload_TV
            echo "TV AND EMU APPLICATIONS KILLED SUCCESSFULLY" > /tmp/PriorityManagerMenuData
         else
            killall -9 CRTVSetup
            killall -9 CRTVCore
            echo 1 > /tmp/PriorityManager_Reload_TV
            echo "TV APPLICATIONS KILLED SUCCESSFULLY" > /tmp/PriorityManagerMenuData
         fi
      else
         echo "PRIORITY MANAGER IS NOT ACTIVE, PLEASE ACTIVATE IT FIRST" > /tmp/PriorityManagerMenuData
      fi
      sync
   ;;


   6 ) # Activate Default Channel List
      if [ -f /DISK2/etc/start.d/S1PriorityManager.sh ]; then
         activateDefault
      else
         echo "PRIORITY MANAGER IS NOT ACTIVE, PLEASE ACTIVATE IT FIRST" > /tmp/PriorityManagerMenuData
      fi
      sync
   ;;


   7 ) # Activate Hidden Channel List
      if [ "$2" != "$HIDDEN_CHN_LST_PASS" ]; then
         echo "INVALID PASSWORD" > /tmp/PriorityManagerMenuData
      elif [ ! -s /DISK2/secondlist.tgz ]; then
         echo "FIRST SAVE A CHANNEL LIST AS HIDDEN CHANNEL LIST" > /tmp/PriorityManagerMenuData
      elif [ -f /DISK2/etc/start.d/S1PriorityManager.sh ]; then
            activateHidden
      else
         echo "PRIORITY MANAGER IS NOT ACTIVE, PLEASE ACTIVATE IT FIRST" > /tmp/PriorityManagerMenuData
      fi
      sync
   ;;


   8 ) # Save Hidden Channel List
      if [ "$2" != "$HIDDEN_CHN_LST_PASS" ]; then
         echo "INVALID PASSWORD" > /tmp/PriorityManagerMenuData
      else
         saveHidden
      fi
      sync
   ;;


   9 ) # Backup
       take_backup
   ;;


   10 ) # Restore
      restore
   ;;


   11 ) # System Information
      echo "###################### UPTIME ##########################" > /tmp/PriorityManagerMenuData
      uptime >> /tmp/PriorityManagerMenuData
      echo "" >> /tmp/PriorityManagerMenuData

      echo "###################### TOP PROCESSES #######################" >> /tmp/PriorityManagerMenuData
      $top -n1 >> /tmp/PriorityManagerMenuData
      echo "" >> /tmp/PriorityManagerMenuData
      
      echo "###################### MEMORY USAGE ######################" >> /tmp/PriorityManagerMenuData
      free >> /tmp/PriorityManagerMenuData
      echo "" >> /tmp/PriorityManagerMenuData
      
      echo "###################### FREE SPACE #########################" >> /tmp/PriorityManagerMenuData
      df >> /tmp/PriorityManagerMenuData
      echo "" >> /tmp/PriorityManagerMenuData
      
      echo "###################### MOUNTS ##########################" >> /tmp/PriorityManagerMenuData
      mount >> /tmp/PriorityManagerMenuData
      echo "" >> /tmp/PriorityManagerMenuData
      
      echo "##################### ALL PROCESSES ########################" >> /tmp/PriorityManagerMenuData
      ps >> /tmp/PriorityManagerMenuData
      echo "" >> /tmp/PriorityManagerMenuData
   ;;


   12 ) # Reset System Passwords
      cp /PLUGINS/PriorityManager/shadow /etc/shadow
      echo "SYSTEM PASSWORDS ARE RESET" > /tmp/PriorityManagerMenuData
   ;;


   13 ) # 
      echo "UNDER CONSTRUCTION" > /tmp/PriorityManagerMenuData
   ;;


   14 ) # 
      echo "UNDER CONSTRUCTION" > /tmp/PriorityManagerMenuData
   ;;


   15 ) # 
      echo "UNDER CONSTRUCTION" > /tmp/PriorityManagerMenuData
   ;;


   16 ) # PRIORITY_MANAGEMENT
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep PRIORITY_MANAGEMENT=|sed 's/PRIORITY_MANAGEMENT=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/PRIORITY_MANAGEMENT=.*/PRIORITY_MANAGEMENT=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "PRIORITY_MANAGEMENT=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   17 ) # MODE
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep MODE=|sed 's/MODE=//'`
      if [ "$CURRENT_VALUE" == "SERVER" ]; then
         NEW_VALUE="CLIENT"
      else
         NEW_VALUE="SERVER"
      fi
      sed "s/MODE=.*/MODE=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "MODE=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   18 ) # DOM_SPEED
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep DOM_SPEED=|sed 's/DOM_SPEED=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/DOM_SPEED=.*/DOM_SPEED=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "DOM_SPEED=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   19 ) # UPGRADE_BUSYBOX
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep UPGRADE_BUSYBOX=|sed 's/UPGRADE_BUSYBOX=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/UPGRADE_BUSYBOX=.*/UPGRADE_BUSYBOX=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "UPGRADE_BUSYBOX=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   20 ) # CRON
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep CRON=|sed 's/CRON=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/CRON=.*/CRON=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "CRON=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   21 ) # SWAPPER
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep SWAPPER=|sed 's/SWAPPER=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/SWAPPER=.*/SWAPPER=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "SWAPPER=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   22 ) # DEEP_SLEEP
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep DEEP_SLEEP=|sed 's/DEEP_SLEEP=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/DEEP_SLEEP=.*/DEEP_SLEEP=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "DEEP_SLEEP=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   23 ) # MOVE_PLUGINS
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep MOVE_PLUGINS=|sed 's/MOVE_PLUGINS=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/MOVE_PLUGINS=.*/MOVE_PLUGINS=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "MOVE_PLUGINS=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   24 ) # SCHEDULED_BACKUP
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep SCHEDULED_BACKUP=|sed 's/SCHEDULED_BACKUP=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/SCHEDULED_BACKUP=.*/SCHEDULED_BACKUP=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "SCHEDULED_BACKUP=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   25 ) # ACTIONS
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep ACTIONS=|sed 's/ACTIONS=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/ACTIONS=.*/ACTIONS=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "ACTIONS=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   26 ) # CIF Mounts
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep CIF_MOUNT=|sed 's/CIF_MOUNT=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/CIF_MOUNT=.*/CIF_MOUNT=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "CIF_MOUNT=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   27 ) # NFS Mounts
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep NFS_MOUNT=|sed 's/NFS_MOUNT=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/NFS_MOUNT=.*/NFS_MOUNT=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "NFS_MOUNT=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   28 ) # VERBOSE_LOG
      CURRENT_VALUE=`cat /DISK2/etc/PriorityManagerSettings.txt | grep VERBOSE_LOG=|sed 's/VERBOSE_LOG=//'`
      if [ "$CURRENT_VALUE" == "0" ]; then
         NEW_VALUE=1
      else
         NEW_VALUE=0
      fi
      sed "s/VERBOSE_LOG=.*/VERBOSE_LOG=$NEW_VALUE/g" /DISK2/etc/PriorityManagerSettings.txt > /DISK2/etc/PriorityManagerSettings.tmp
      mv /DISK2/etc/PriorityManagerSettings.tmp /DISK2/etc/PriorityManagerSettings.txt
      chmod 755 /DISK2/etc/PriorityManagerSettings.txt
      echo "VERBOSE_LOG=$NEW_VALUE" > /tmp/PriorityManagerMenuData
      sync
   ;;


   29 ) # Settings
      cat /DISK2/etc/PriorityManagerSettings.txt | egrep -v "#HIDE#" > /tmp/PriorityManagerMenuData
   ;;


   30 ) # Read Me
      cat /PLUGINS/PriorityManager/readme.txt > /tmp/PriorityManagerMenuData
   ;;

esac

echo " " > /tmp/PriorityManagerMenuReady

exit
