#!/bin/sh
# 
# PRIORITY MANAGER V1.8 BY BUYUKBANG
#
#########################################################################################
#
# PLEASE READ FOLLOWING FILE FOR MORE INFORMATION: /PLUGINS/PriorityManager/readme.txt
#
#########################################################################################

if [ -f /DISK2/etc/PriorityManagerSettings.txt ]; then
   dos2unix /DISK2/etc/PriorityManagerSettings.txt
   . /DISK2/etc/PriorityManagerSettings.txt
else
   exit
fi

crond="/PLUGINS/PriorityManager/busybox crond"
crontab="/PLUGINS/PriorityManager/busybox crontab"
hdparm="/PLUGINS/PriorityManager/busybox hdparm"
nohup="/PLUGINS/PriorityManager/busybox nohup"
realpath="/PLUGINS/PriorityManager/busybox realpath"

SLEEPING=0
SLEEP_SWITCHED=0
RSSPOLARIS=0
PLUGINSNANOX=0
MOUNTED=0
ALREADY_MOUNTED=0
PING_WARNING=0
MOUNT_WARNING=0
SWAPPED=0
SWAP_WARNING1=0
SWAP_WARNING2=1
RECORDING_OLD=0
RECORDING_NEW=0
MOUNT_ONLINE=0
TV=0
LAST_MENU=
CURRENT_MENU=
RECORDDEV=
RECORDFILE_OLD=0
RECORDFILE_NEW=0
MENU_SWITCHED=0
SELENE_OLD=
SELENE_NEW=
ACTION_STATE=
ACTION_DATE=0
REAL_CHECK_PATH=
PLUGINS_MOVED=0
BUSYBOX_UPGRADED=0
NEXT_BACKUP_DATE=0
SDS_OLD_PID=0
SDS_NEW_PID=0
MENU_SWITCH_TIME=0

if [ "$VERBOSE_LOG" == 1 ]; then
   exec 1>>/Download/PriorityManager_Verbose_Log 2>>/Download/PriorityManager_Verbose_Log
   set -x
fi

check_log_size () {
   if [ "$VERBOSE_LOG" == 1 ]; then
      if [ "$(ls -l /Download/PriorityManager_Verbose_Log | awk '{ print $5 }')" -gt $MAX_LOG_SIZE  ]; then
       set +x
       exec 1>/dev/null 2>/dev/null
       rm -f /Download/PriorityManager_Verbose_Log
       exec 1>>/Download/PriorityManager_Verbose_Log 2>>/Download/PriorityManager_Verbose_Log
       set -x
      fi
   fi
}

printlog() {
   ACTION_DATE=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime()+'$WAIT_MINUTES'*60)}'`
   if [ "$CURRENT_MENU" == "SLEEP" ]; then
      ACTION_STATE=S
   else
      ACTION_STATE=W
   fi
   echo $CURRENT_MENU > /tmp/PriorityManager_Last_Menu
   echo $"`date '+%H:%M:%S %m/%d/%y'`": "$LAST_MENU=>$CURRENT_MENU TV=$TV R=$RECORDING_NEW M=$MOUNTED S=$SWAPPED A=$ACTION_STATE BU=$BUSYBOX_UPGRADED C=$CRON P=$PLUGINS_MOVED BA=$SCHEDULED_BACKUP" >> /tmp/PriorityManager_IsRunning
}

take_backup() {
   if [ "$SCHEDULED_BACKUP" == 1 ]; then
      CURRENT_DATE=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}'`
      if [ $NEXT_BACKUP_DATE != "" ] && [ $CURRENT_DATE -lt $NEXT_BACKUP_DATE ];then 
         return
      fi

      echo $"`date '+%H:%M:%S %m/%d/%y'`": "BACKUP STARTED => $BACKUP_PATH/$CURRENT_DATE" >> /tmp/PriorityManager_IsRunning
      mkdir $BACKUP_PATH
      mkdir $BACKUP_PATH/$CURRENT_DATE
      dircount=0
      
      if [ "$COMPRESSED_BACKUP" == 0 ]; then
         cp -rf /DISK2 $BACKUP_PATH/$CURRENT_DATE/DISK2
         sync
         if [ ! -d $BACKUP_PATH/$CURRENT_DATE/DISK2 ];then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "BACKUP OF /DISK2 FAILED" >> /tmp/PriorityManager_IsRunning
            return
         fi
         cp -rf /PLUGINS $BACKUP_PATH/$CURRENT_DATE/PLUGINS
         sync
         if [ ! -d $BACKUP_PATH/$CURRENT_DATE/PLUGINS ];then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "BACKUP OF /PLUGINS FAILED" >> /tmp/PriorityManager_IsRunning
            return
         fi
      else
         rm -f $BACKUP_PATH/$CURRENT_DATE/DISK2.tar.gz
         tar -czf $BACKUP_PATH/$CURRENT_DATE/DISK2.tar.gz /DISK2
         sync
         if [ ! -f $BACKUP_PATH/$CURRENT_DATE/DISK2.tar.gz ];then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "BACKUP OF /DISK2 FAILED" >> /tmp/PriorityManager_IsRunning
            return
         fi
         rm -f $BACKUP_PATH/$CURRENT_DATE/PLUGINS.tar.gz
         tar -czf $BACKUP_PATH/$CURRENT_DATE/PLUGINS.tar.gz /PLUGINS
         sync
         if [ ! -f $BACKUP_PATH/$CURRENT_DATE/PLUGINS.tar.gz ];then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "BACKUP OF /PLUGINS FAILED" >> /tmp/PriorityManager_IsRunning
            return
         fi
      fi

      for dir in `ls -lr1 $BACKUP_PATH/ | awk '{ print $7 }'` ; do
         if [ -d $BACKUP_PATH/$dir ]; then
            if [ $dircount -ge $NUMBER_OF_BACKUPS ];then 
               echo $"`date '+%H:%M:%S %m/%d/%y'`": "DELETING OLD BACKUP $BACKUP_PATH/$dir" >> /tmp/PriorityManager_IsRunning
               rm -fr $BACKUP_PATH/$dir
            fi
            let dircount=dircount+1
         fi
      done

      NEXT_BACKUP_DATE=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime()+'$BACKUP_FREQUENCY'*86400)}'`
      echo $NEXT_BACKUP_DATE > /PLUGINS/PriorityManager/next_backup_date 
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "BACKUP COMPLETED" >> /tmp/PriorityManager_IsRunning
      sync
   fi
}

upgrade_busybox() {
   if [ "$UPGRADE_BUSYBOX" == 1 ]; then
      if [ "$(/bin/busybox --help 2>&1 | grep "BusyBox v1.16.1"|wc -l)" -gt 0  ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "BUSYBOX ALREADY UPGRADED" >> /tmp/PriorityManager_IsRunning
         BUSYBOX_UPGRADED=1
      else
         echo $"`date '+%H:%M:%S %m/%d/%y'`": "UPGRADING BUSYBOX" >> /tmp/PriorityManager_IsRunning
         cp -f /PLUGINS/PriorityManager/busybox /bin/busybox
         cd /bin
         ./busybox --help 2>&1| grep 'Currently defined functions:' -A30 |  egrep -v "Currently defined functions:" | awk '{gsub(/,|\[/,"\n");print}' | egrep -v 'sh$|busybox'|xargs -rn 1 ln -sf busybox 
         if [ "$(/bin/busybox --help 2>&1 | grep "BusyBox v1.16.1"|wc -l)" -gt 0  ]; then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "BUSYBOX UPGRADED" >> /tmp/PriorityManager_IsRunning
            BUSYBOX_UPGRADED=1
         else
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "BUSYBOX UPGRADE FAILED" >> /tmp/PriorityManager_IsRunning
         fi
         sync  
      fi
   fi
}

swapper() {
   if [ "$SWAPPER" == 1 ] && [ "$SWAPPED" == 0 ]; then
      if [ "$(free | grep "Swap:            0"|wc -l)" -gt 0  ]; then
        if [ "$(mount | grep "on "$SWAPDEVICE" type"|wc -l)" -lt 1  ]; then
           if [ "$SWAP_WARNING1" == 0 ]; then
              echo $"`date '+%H:%M:%S %m/%d/%y'`": $SWAPDEVICE NOT MOUNTED, TRIALS WILL CONTINUE >> /tmp/PriorityManager_IsRunning
              SWAP_WARNING1=1
           fi
           return
        elif [ -e $SWAPDEVICE/swapfile ]; then
           echo $"`date '+%H:%M:%S %m/%d/%y'`": USING EXISTING SWAP FILE >> /tmp/PriorityManager_IsRunning
        else 
           echo $"`date '+%H:%M:%S %m/%d/%y'`": CREATING A NEW SWAP FILE >> /tmp/PriorityManager_IsRunning
           dd if=/dev/zero of=$SWAPDEVICE/swapfile bs=1024 count=$SWAPSIZE  
           mkswap $SWAPDEVICE/swapfile
           sync
        fi
        swapon $SWAPDEVICE/swapfile
        sync
        if [ "$(free | grep "Swap:            0"|wc -l)" -eq 0  ]; then
           echo $"`date '+%H:%M:%S %m/%d/%y'`": SWAP FILE ACTIVATED >> /tmp/PriorityManager_IsRunning
           free >> /tmp/PriorityManager_IsRunning
           echo "" >> /tmp/PriorityManager_IsRunning
           SWAPPED=1
        else
           if [ "$SWAP_WARNING2" == 0 ]; then
              echo $"`date '+%H:%M:%S %m/%d/%y'`": SWAP FILE ACTIVATION FAILED, TRIALS WILL CONTINUE >> /tmp/PriorityManager_IsRunning
              SWAP_WARNING2=1
           fi
           rm -f $SWAPDEVICE/swapfile
           return
        fi
      else
        echo $"`date '+%H:%M:%S %m/%d/%y'`": SWAP FILE ALREADY ACTIVATED >> /tmp/PriorityManager_IsRunning
        SWAPPED=1
      fi
   fi
}

check_mount() {
   MOUNT_ONLINE=0
   if [ "$(mount | grep $REAL_CHECK_PATH | wc -l)" -lt 1  ]; then
      return
   fi
   rm -f /tmp/PriorityManager_CheckPath
   du -sk $CHECK_PATH > /tmp/PriorityManager_CheckPath &
   SLEEP_COUNTER=0
   while [ "$SLEEP_COUNTER" -lt 30 ]; do
      sleep 1
      if [ -s /tmp/PriorityManager_CheckPath ] ;then
         MOUNT_ONLINE=1
         return
      fi
     let SLEEP_COUNTER=SLEEP_COUNTER+1
   done
   kill -9 $!
}

mounter() {
   if [ "$CIF_MOUNT" != 0 ] || [ "$NFS_MOUNT" != 0 ]; then
      if [ "$(ping -c 2 $REMOTE_IP | grep " 0% packet loss" | wc -l)" -lt 1  ]; then
         if [ "$MOUNTED" == 1 ]; then  ### Connection lost, unmount all mounted shares      
            for MOUNT_POINT in `mount | grep $REMOTE_IP | awk -F" on " '{print $2}' | awk -F" type " '{print $1}'`; do
               umount -lf $MOUNT_POINT
            done
            MOUNTED=0
            ALREADY_MOUNTED=0
            PING_WARNING=1
            echo $"`date '+%H:%M:%S %m/%d/%y'`": FILE SERVER IS OFFLINE, SHARES UNMOUNTED >> /tmp/PriorityManager_IsRunning
         elif [ "$MOUNTED" == 0 ] && [ "$PING_WARNING" == 0 ]; then  ### No connection, print warning message only for first time
            PING_WARNING=1
            echo $"`date '+%H:%M:%S %m/%d/%y'`": FILE SERVER IS OFFLINE, SHARES CANNOT BE MOUNTED >> /tmp/PriorityManager_IsRunning
         fi
         return
      elif [ "$MOUNTED" == 1 ]; then
         return
      fi
      check_mount
      if [ "$MOUNT_ONLINE" == 0 ]; then
         if [ "$CIF_MOUNT" == 1 ]; then
            INDEX=1
            while [ "$INDEX" -le "${#CIF[@]}" ]; do
               CIF_COMMAND=${CIF[$INDEX]}
               if [ "$CIF_COMMAND" != "" ]; then
                  $CIF_COMMAND &
               fi
               let INDEX=INDEX+1
            done
            check_mount
            if [ "$MOUNT_ONLINE" == 1 ]; then
               MOUNTED=1
               ALREADY_MOUNTED=1
               PING_WARNING=0
               MOUNT_WARNING=0
               echo $"`date '+%H:%M:%S %m/%d/%y'`": CIF MOUNT COMPLETED >> /tmp/PriorityManager_IsRunning
               mount | grep $REMOTE_IP | awk '{print $1" "$2" "$3" "$4" "$5}' >> /tmp/PriorityManager_IsRunning
               echo "" >> /tmp/PriorityManager_IsRunning
            elif [ "$MOUNT_WARNING" == 0 ]; then
               MOUNT_WARNING=1
               echo $"`date '+%H:%M:%S %m/%d/%y'`": NFS MOUNT FAILED, CHECK PATH IS EMPTY, TRIALS WILL CONTINUE >> /tmp/PriorityManager_IsRunning
            fi
         fi
         if [ "$NFS_MOUNT" == 1 ]; then
            INDEX=1
            while [ "$INDEX" -le "${#NFS[@]}" ]; do
               NFS_COMMAND=${NFS[$INDEX]}
               if [ "$NFS_COMMAND" != "" ]; then
                  $NFS_COMMAND &
               fi
               let INDEX=INDEX+1
            done
            check_mount
            if [ "$MOUNT_ONLINE" == 1 ]; then
               MOUNTED=1
               ALREADY_MOUNTED=1
               PING_WARNING=0
               MOUNT_WARNING=0
               echo $"`date '+%H:%M:%S %m/%d/%y'`": NFS MOUNT COMPLETED >> /tmp/PriorityManager_IsRunning
               mount | grep $REMOTE_IP | awk '{print $1" "$2" "$3" "$4" "$5}' >> /tmp/PriorityManager_IsRunning
               echo "" >> /tmp/PriorityManager_IsRunning
            elif [ "$MOUNT_WARNING" == 0 ]; then
               MOUNT_WARNING=1
               echo $"`date '+%H:%M:%S %m/%d/%y'`": NFS MOUNT FAILED, CHECK PATH IS EMPTY, TRIALS WILL CONTINUE >> /tmp/PriorityManager_IsRunning
            fi
         fi
      elif [ "$ALREADY_MOUNTED" == 0 ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": MOUNTS ALREADY EXIST >> /tmp/PriorityManager_IsRunning
         MOUNTED=1
         ALREADY_MOUNTED=1
         PING_WARNING=0
         MOUNT_WARNING=0
      fi
   fi
}

deep_sleep() {
   if [ "$MODE" != "SERVER" ]; then
      killall -9 emu_module
      killall -9 mgcamd
      killall -9 mbox_module
      killall -9 sbox.sigma
      killall -9 oscam
      killall -9 dvbapi_module
      killall -9 CCcam.mipsel
      killall -9 deformhandlerV1ac
      killall -9 newcs
      killall -9 newcs.sigma.usb
      killall -9 newcs.sigma.pcsc
   fi
   killall -9 cheops_module
   killall -9 DStar
   killall -9 file_control
   killall -9 JIPC_Server
   killall -9 SDecoderServer
   killall -9 event_dispatcher
   killall -9 app_control
   killall -9 rssfeed
   killall -9 Polaris
   killall -9 browser_control
   killall -9 sample_module
   killall -9 CRTVSetup
   killall -9 E_TUNER.A
   killall -9 SeleneTVCore
   killall -9 CRTVCore
   killall -9 TEMSControl
   killall -9 TVPortal_Player
   killall -9 TVPortalCore
   killall -9 youtube_player
   killall -9 radio_test
   killall -9 detector_test
   killall -9 boot_controler
   killall -9 update_agent
   killall -9 inadyn-advanced
   killall -9 EStar
   killall -9 JPlugins
   killall -9 S.sh
   killall -9 nano-X
   snice telnetd cifsdnotifyd cifsoplockd amulecmd amuleweb transmission-remote -10
   snice vsftpd smbd nmbd amuled transmission-daemon -20
}

execute_actions() {
   if [ "$CURRENT_MENU" == "SLEEP" ] && [ "$ACTION_STATE" == W  ]; then
      return
   elif [ "$CURRENT_MENU" != "SLEEP" ] && [ "$ACTION_STATE" == S ]; then
      return
   elif [ "$CURRENT_MENU" != "SLEEP" ] && [ "$LAST_MENU" != "SLEEP" ]; then
      return
   fi
   
   if [ "$ACTIONS" == 1 ] && [ "$RECORDING_NEW" == 0 ] && [ $ACTION_DATE -le "$(awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}')" ];then
      if [ "${#SLEEP_ACTION[*]}" != "${#WAKEUP_ACTION[*]}" ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`":  "MISSING ACTION DEFINITION!" >> /tmp/PriorityManager_IsRunning
         ACTIONS=0
         return
      fi
      
      INDEX=1
      
      while [ "$INDEX" -le "${#SLEEP_ACTION[@]}" ]; do
         if [ "$ACTION_STATE" == S  ];then
            CURRENT_ACTION=${SLEEP_ACTION[$INDEX]}
            OPPOSITE_ACTION=${WAKEUP_ACTION[$INDEX]}
         elif [ "$ACTION_STATE" == W ];then
            CURRENT_ACTION=${WAKEUP_ACTION[$INDEX]}
            OPPOSITE_ACTION=${SLEEP_ACTION[$INDEX]}
         fi
         
         if [ "$CURRENT_ACTION" == "KILL" ];then
            if [ "$(grep "$OPPOSITE_ACTION" /tmp/PriorityManager_Process_List|wc -l)" -lt 1 ]; then
               echo $"`date '+%H:%M:%S %m/%d/%y'`":  "$OPPOSITE_ACTION IS NOT RUNNING" >> /tmp/PriorityManager_IsRunning
            else
               kill -9 `ps | grep "$OPPOSITE_ACTION" | egrep -v grep | awk '{print $1}'`
               echo $"`date '+%H:%M:%S %m/%d/%y'`":  "$OPPOSITE_ACTION KILLED" >> /tmp/PriorityManager_IsRunning
            fi
         elif [ "$CURRENT_ACTION" != "" ];then
            if [ "$(grep "$CURRENT_ACTION" /tmp/PriorityManager_Process_List|wc -l)" -lt 1 ]; then
               $CURRENT_ACTION &
               echo $"`date '+%H:%M:%S %m/%d/%y'`":  "$CURRENT_ACTION EXECUTED" >> /tmp/PriorityManager_IsRunning
               sleep 1
            else
               echo $"`date '+%H:%M:%S %m/%d/%y'`":  "$CURRENT_ACTION IS ALREADY RUNNING" >> /tmp/PriorityManager_IsRunning
            fi
         fi
         
         let INDEX=INDEX+1
      done
      if [ "$DEEP_SLEEP" == 1 ] && [ "$CURRENT_MENU" == "SLEEP" ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": ACTIONS STARTED, PRIORTY MANAGER WILL BE TERMINATED BY DEEP SLEEP >> /tmp/PriorityManager_IsRunning
         exit
      fi
      if [ "$CURRENT_MENU" == "SLEEP" ] && [ "$ACTION_STATE" == S  ];then
         ACTION_STATE=W
      elif [ "$CURRENT_MENU" != "SLEEP" ] && [ "$ACTION_STATE" == W ];then
         ACTION_STATE=S
      else
         return
      fi
      ACTION_DATE=0
   fi
}

check_sleep() {
   SLEEP_SWITCHED=0
   if [ -f /tmp/PriorityManager_Sleep ]; then
      SLEEPING=1
      if [ "$CURRENT_MENU" != "SLEEP" ]; then
         SLEEP_SWITCHED=1
      fi
   else
      SLEEPING=0
      if [ "$CURRENT_MENU" == "SLEEP" ]; then
         SLEEP_SWITCHED=1
      fi
   fi
}

check_recording() {
   #CHECK-1
   if [ "$RECORDING_NEW" == 0 ] && [ $SDS_OLD_PID -eq $SDS_NEW_PID ] ;then
      RECORDING_NEW=0
      return
   fi
   let SDS_OLD_PID=$SDS_NEW_PID

   #CHECK-2
   if [ ! -s /DISK2/reserved.dat ] ;then
      RECORDING_NEW=0
      return
   fi

   #CHECK-3
   if [ "$(hdparm -C $RECORDDEV | grep standby | wc -l)" -gt 0 ]; then
      RECORDING_NEW=0
      return
   fi
   
   #CHECK-4
   RECORDFILE_NEW=`du -sk /DATA/recordfile/ | awk '{ print $1 }'`
   if [ $RECORDFILE_NEW -eq $RECORDFILE_OLD  ]; then
      RECORDING_NEW=0
      RECORDFILE_OLD=$RECORDFILE_NEW
      return
   fi

   #CHECK-5
   if [ "$(ls /DATA/recordfile/*.idx 2> /dev/null | wc -l)" -eq 0  ]; then
       RECORDING_NEW=0
       return
   fi 
    
   RECORDING_NEW=1
}

check_menu() {
   SELENE_NEW=`ls -l /DISK2/selene.conf  | awk '{ print $6$7$8 }'`
   if [ "$SELENE_NEW" == "$SELENE_OLD" ]; then
      MENU_SWITCHED=0
   else
      MENU_SWITCHED=1
      SELENE_OLD=$SELENE_NEW
   fi
}

manage_priority() {
   if [ "$DYNAMIC_SLEEP" == 0 ]; then
      if [ "$CURRENT_MENU" != "" ]; then  # first loop
         sleep $MAJOR_SLEEP_TIME
      fi
      
      check_sleep
      
      if [ -f /tmp/PriorityManager_Reload_TV ] || [ -f /tmp/PriorityManager_Reload_TV2 ] ; then
         if [ "$(ps | grep "reload_tv.sh" | egrep -v grep |wc -l)" -eq 0  ]; then
            rm -f PriorityManager_Reload_TV_Running
            [ -f /tmp/PriorityManager_Reload_TV ] && $nohup /bin/sh /PLUGINS/PriorityManager/reload_tv.sh 1 > /dev/null &
            [ -f /tmp/PriorityManager_Reload_TV2 ] && $nohup /bin/sh /PLUGINS/PriorityManager/reload_tv.sh 0 > /dev/null &
         fi
         rm -f /tmp/PriorityManager_Reload_TV /tmp/PriorityManager_Reload_TV2
      fi
   else
      if [ "$CURRENT_MENU" == "" ]; then  # first loop
         check_sleep
      else
         #Dynamic calculation of sleep time (0-30 seconds)
         SLEEP_AMOUNT=`expr 30 - "$(date "+%S")" % 30`
         SLEEP_COUNTER=1
         while [ "$SLEEP_COUNTER" -lt "$SLEEP_AMOUNT" ]; do     	 
            check_menu
            if [ "$MENU_SWITCHED" == 1 ]; then
               break
            fi
            
            check_sleep
            if [ "$SLEEP_SWITCHED" == 1 ]; then
               break
            fi

            if [ -f /tmp/PriorityManager_Reload_TV ] || [ -f /tmp/PriorityManager_Reload_TV2 ] ; then
               if [ "$(ps | grep "reload_tv.sh" | egrep -v grep |wc -l)" -eq 0  ]; then
                  rm -f PriorityManager_Reload_TV_Running
                  [ -f /tmp/PriorityManager_Reload_TV ] && $nohup /bin/sh /PLUGINS/PriorityManager/reload_tv.sh 1 > /dev/null &
                  [ -f /tmp/PriorityManager_Reload_TV2 ] && $nohup /bin/sh /PLUGINS/PriorityManager/reload_tv.sh 0 > /dev/null &
               fi
               rm -f /tmp/PriorityManager_Reload_TV /tmp/PriorityManager_Reload_TV2
            fi
            
            sleep $MINOR_SLEEP_TIME
            let SLEEP_COUNTER=SLEEP_COUNTER+$MINOR_SLEEP_TIME
         done
      fi
   fi

   if [ "$KILL_TV_EMU" == "1" ] && [ "$MENU_SWITCH_TIME" != "0" ]; then
      if [ "$(awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime()-'$WAIT_SECONDS_BEFORE_KILL')}')" -gt $MENU_SWITCH_TIME ];then 
         MENU_SWITCH_TIME=0
         if [ "$MODE" != "SERVER" ]; then
            chmod 755 /tmp/kill_EMUs.sh; /tmp/kill_EMUs.sh
         fi
         killall -9 CRTVSetup
         killall -9 CRTVCore
         if [ "$(ps | grep "reload_tv.sh" | egrep -v grep |wc -l)" -eq 0  ]; then
            rm -f PriorityManager_Reload_TV_Running
            $nohup /bin/sh /PLUGINS/PriorityManager/reload_tv.sh 1 > /dev/null &
         fi
         if [ "$MODE" != "SERVER" ]; then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "TV AND EMU APPLICATIONS KILLED" >> /tmp/PriorityManager_IsRunning
         else
            echo $"`date '+%H:%M:%S %m/%d/%y'`": "TV APPLICATIONS KILLED" >> /tmp/PriorityManager_IsRunning
         fi
      fi
   fi

   LAST_MENU=`cat /tmp/PriorityManager_Last_Menu`
   ps > /tmp/PriorityManager_Process_List
   TV=`grep CRTVCore /tmp/PriorityManager_Process_List|wc -l`
   let TV=TV  #Because needs trimming
   let SDS_NEW_PID=`grep SDecoderServer /tmp/PriorityManager_Process_List | head -n1 | awk '{ print $3 }'`
   BROWSER2=`grep Polaris /tmp/PriorityManager_Process_List|wc -l`
   RSSFEED=`grep rssfeed /tmp/PriorityManager_Process_List|wc -l`
   NANOX=`grep nano-X /tmp/PriorityManager_Process_List|wc -l`
   SMB=`grep smbd /tmp/PriorityManager_Process_List|wc -l`
   #MEDIA=`grep SDecoderServer /tmp/PriorityManager_Process_List|wc -l`
   #YOUTUBE=`grep youtube_player /tmp/PriorityManager_Process_List|wc -l`
   #PHOTO=`grep EStar /tmp/PriorityManager_Process_List|wc  -l`
   #BROWSER=`grep browser_control /tmp/PriorityManager_Process_List|wc -l`

   CURRENT_MENU=`cat /DISK2/selene.conf|grep currnt_menu=|sed 's/currnt_menu=//'`
   if [ "$SLEEPING" == 1 ] && [ $SMB -gt 0 ]; then
      CURRENT_MENU=SLEEP
   elif [ $TV -gt 12 ]; then
      CURRENT_MENU=TV
   fi

   check_recording

   if [ "$RECORDING_OLD" == 0 ] && [ "$RECORDING_NEW" == 1 ]; then
      echo $"`date '+%H:%M:%S %m/%d/%y'`": TV RECORDING DETECTED, TV PRIORITIZATION WILL BE APPLIED >> /tmp/PriorityManager_IsRunning
         RECORDING_OLD=1
         snice DStar -1
         snice SDecoderServer -10
         snice kswapd0 pdflush pdflush xfsbufd -10
      if [ "$CURRENT_MENU" == "TV" ]; then
         RECORDING_OLD=1
         snice STOP DStar SDecoderServer
         snice DStar -1
         snice SDecoderServer -10
      else
         CURRENT_MENU=TV
         LAST_MENU=
      fi
   elif [ "$RECORDING_OLD" == 1 ] && [ "$RECORDING_NEW" == 0 ]; then
      echo $"`date '+%H:%M:%S %m/%d/%y'`": TV RECORDING ENDED >> /tmp/PriorityManager_IsRunning
      RECORDING_OLD=0
       if [ "$CURRENT_MENU" == "TV" ]; then
       	  snice STOP DStar SDecoderServer
          snice DStar -19
          snice SDecoderServer -5
       fi
   elif [ "$RECORDING_NEW" == 1 ]; then
      CURRENT_MENU=TV
      LAST_MENU=TV
   fi
    
   if [ "$CURRENT_MENU" == "SLEEP" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      MENU_SWITCH_TIME=0
      if [ "$DEEP_SLEEP" == 1 ]; then
         echo $"`date '+%H:%M:%S %m/%d/%y'`": ACTIVATING DEEP SLEEP MODE >> /tmp/PriorityManager_IsRunning
         deep_sleep
         if [ "$PROGRAMS" == 0 ]; then
            echo $"`date '+%H:%M:%S %m/%d/%y'`": PRIORTY MANAGER WILL BE TERMINATED BY DEEP SLEEP >> /tmp/PriorityManager_IsRunning
            exit
         fi
      else
         snice STOP DStar SDecoderServer file_control CRTVCore CRTVSetup cheops_module JIPC_Server
         if [ "$MODE" != "SERVER" ]; then
            snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
         fi
         snice telnetd amulecmd transmission-remote amuleweb -5
         snice vsftpd smbd nmbd amuled transmission-daemon -20
         snice cifsdnotifyd cifsoplockd -10
         if [ $BROWSER2 -gt 0 ]; then
            killall -9 Polaris
         fi 
         if [ $RSSFEED -gt 0 ]; then
            killall -9 rssfeed
         fi
         RSSPOLARIS=0
         PLUGINSNANOX=0
      fi
   elif [ "$CURRENT_MENU" == "TV" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ]; then
      printlog
      MENU_SWITCH_TIME=0
      while [ "$(ps | grep "reload_tv.sh" | egrep -v grep |wc -l)" -gt 0  ]; do 
         sleep 2
      done
      if [ "$RECORDING_NEW" == 0 ]; then
         snice DStar -19
         snice SDecoderServer -5
      fi
      snice CRTVCore -19
      snice CRTVSetup -1
      snice STOP cheops_module JIPC_Server telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote file_control
      snice cheops_module 2
      if [ "$MODE" != "SERVER" ]; then
          snice mbox_module sbox.sigma oscam newcs newcs.sigma.usb newcs.sigma.pcsc -6
          snice emu_module mgcamd dvbapi_module CCcam.mipsel deformhandlerV1ac -5
      fi
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi 
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "VIDEO" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      if [ $TV -gt 0 ]; then
         MENU_SWITCH_TIME=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}'`
      else
         MENU_SWITCH_TIME=0
      fi
      snice DStar -4
      snice SDecoderServer -20 
      snice file_control -5
      snice STOP CRTVCore CRTVSetup cheops_module JIPC_Server telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "AUDIO" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      MENU_SWITCH_TIME=0
      snice DStar -4
      snice SDecoderServer -20 
      snice file_control -5
      snice STOP CRTVCore CRTVSetup cheops_module JIPC_Server telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi 
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "YOUTUBE" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      MENU_SWITCH_TIME=0
      snice DStar -4
      snice SDecoderServer -10
      snice JIPC_Server -1
      snice youtube_player -19
      snice STOP CRTVCore CRTVSetup cheops_module file_control telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi 
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "PHOTO" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      MENU_SWITCH_TIME=0
      snice DStar -4
      snice file_control -5 
      snice EStar -19
      snice STOP CRTVCore CRTVSetup SDecoderServer cheops_module JIPC_Server telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi 
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "BROWSER" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      if [ $TV -gt 0 ]; then
         MENU_SWITCH_TIME=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}'`
      else
         MENU_SWITCH_TIME=0
      fi
      snice Polaris browser_control -18
      snice JIPC_Server -1 
      snice STOP CRTVCore CRTVSetup SDecoderServer cheops_module telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote DStar SDecoderServer file_control
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi 
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "RSSFEED" ] && [ "$RECORDING_NEW" == 0 ]; then
      if [ "$CURRENT_MENU" != "$LAST_MENU" ]; then
         printlog
         if [ $TV -gt 0 ]; then
            MENU_SWITCH_TIME=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}'`
         else
            MENU_SWITCH_TIME=0
         fi
         snice rssfeed -18
         snice JIPC_Server -1
         snice STOP CRTVCore CRTVSetup SDecoderServer cheops_module telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote DStar SDecoderServer file_control
         if [ "$MODE" != "SERVER" ]; then
            snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
         fi
         RSSPOLARIS=0
         PLUGINSNANOX=0
      elif [ "$RSSPOLARIS" == "0" ] && [ $BROWSER2 -gt 0 ]; then
         snice Polaris browser_control -18
         RSSPOLARIS=1
      fi
   elif [ "$CURRENT_MENU" == "SETUP" ] && [ "$CURRENT_MENU" != "$LAST_MENU" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      MENU_SWITCH_TIME=0
      snice DStar -10
      snice JIPC_Server -1
      snice CRTVCore -4
      snice CRTVSetup -8
      snice STOP SDecoderServer file_control cheops_module telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi 
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "PLUGINS" ] && [ "$RECORDING_NEW" == 0 ]; then
      if [ "$CURRENT_MENU" != "$LAST_MENU" ]; then
         printlog
         MENU_SWITCH_TIME=0
         snice JPlugins DStar -10
         snice JIPC_Server -5 
         snice STOP CRTVCore CRTVSetup SDecoderServer file_control cheops_module telnetd vsftpd cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
         if [ "$MODE" != "SERVER" ]; then
            snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
         fi
         if [ $BROWSER2 -gt 0 ]; then
            killall -9 Polaris
         fi 
         if [ $RSSFEED -gt 0 ]; then
            killall -9 rssfeed
         fi 
         RSSPOLARIS=0
         PLUGINSNANOX=0
      elif [ "$PLUGINSNANOX" == "0" ] && [ $NANOX -gt 0 ]; then
         snice nano-X -10
         PLUGINSNANOX=1
      elif [ $NANOX == 0 ]; then
         PLUGINSNANOX=0
      fi
   elif [ "$CURRENT_MENU" == "FTP" ] && [ "$LAST_MENU" != "FTP" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      MENU_SWITCH_TIME=0
      snice DStar -10
      snice telnetd -1
      snice vsftpd -5
      snice STOP SDecoderServer file_control CRTVCore CRTVSetup cheops_module JIPC_Server cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi
      RSSPOLARIS=0
      PLUGINSNANOX=0
   elif [ "$CURRENT_MENU" == "FILE_MANAGER" ] && [ "$LAST_MENU" != "FILE_MANAGER" ] && [ "$RECORDING_NEW" == 0 ]; then
      printlog
      MENU_SWITCH_TIME=0
      snice DStar -10
      snice telnetd -1
      snice vsftpd -5
      snice file_control -15
      snice STOP SDecoderServer CRTVCore CRTVSetup cheops_module JIPC_Server cifsdnotifyd cifsoplockd amulecmd amuled amuleweb transmission-daemon transmission-remote
      if [ "$MODE" != "SERVER" ]; then
         snice STOP emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc
      fi
      if [ $BROWSER2 -gt 0 ]; then
         killall -9 Polaris
      fi 
      if [ $RSSFEED -gt 0 ]; then
         killall -9 rssfeed
      fi
      RSSPOLARIS=0
      PLUGINSNANOX=0
   fi
}


echo "Starting Priority Manager"
START_DATE=`awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime())}'`
rm -f /tmp/PriorityManager_Last_Menu /tmp/PriorityManager_Process_List /tmp/PriorityManager_CheckPath
echo START > /tmp/PriorityManager_Last_Menu
if [ -f /tmp/PriorityManager_LogStarted ];then
   rm -f  /tmp/PriorityManager_LogStarted
   if [ "$(mount | grep "$TARGET_DEVICE on /PLUGINS type" | wc -l)" -gt 0  ]; then
      PLUGINS_MOVED=1
   fi
else
   rm -f /tmp/PriorityManager_IsRunning
   echo "PRIORITY MANAGER V1.8 BY BUYUKBANG" > /tmp/PriorityManager_IsRunning
   echo "R:RECORD M:MOUNT S:SWAP A:ACTION BU:BUSYBOX C:CRON P:PLUGINS BA:BACKUP" >> /tmp/PriorityManager_IsRunning
fi
if [ "$DOM_SPEED" == 1 ]; then
   echo $"`date '+%H:%M:%S %m/%d/%y'`": "INCREASING INTERNAL STORAGE (DOM) SPEED" >> /tmp/PriorityManager_IsRunning
   #hdparm -m0 -c0 -u0 -a1024 -k0 /dev/hda
   /PLUGINS/PriorityManager/busybox hdparm -a1024 -A1 -c1 -d1 -m1 -u1 /dev/hda
fi
upgrade_busybox
${0%%.s*} 0 > /dev/null &
if [ "$CRON" == 1 ]; then
   if [ "$(ps | grep "/PLUGINS/PriorityManager/busybox crond" | egrep -v grep |wc -l)" -gt 0  ]; then
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "CRON ALREADY ACTIVATED" >> /tmp/PriorityManager_IsRunning
   else
      ln -sf /PLUGINS/PriorityManager/cron /tmp/cron     
      $crond
      echo $"`date '+%H:%M:%S %m/%d/%y'`": "CRON ACTIVATED" >> /tmp/PriorityManager_IsRunning
      $crontab -l >> /tmp/PriorityManager_IsRunning
      echo -e "\n" >> /tmp/PriorityManager_IsRunning
   fi
fi
if [ "$(awk 'BEGIN{print strftime("%y%m%d%H%M%S",systime()-10)}')" -gt $START_DATE ];then 
    sleep 10
fi

cp /DISK2/.profile /root/.profile

cp /DISK2/etc/start.d/hosts /etc/hosts

if [ "$PRIORITY_MANAGEMENT" == 1 ]; then
   snice ir_control -20
   snice _azepgmgr 5
   snice openvpn -6
   if [ "$MODE" == "SERVER" ]; then
      snice mbox_module sbox.sigma oscam newcs newcs.sigma.usb newcs.sigma.pcsc -6
      snice emu_module mgcamd dvbapi_module CCcam.mipsel deformhandlerV1ac -5
   fi
   SELENE_OLD=`ls -l /DISK2/selene.conf  | awk '{ print $6$7$8 }'`
   RECORDDEV=`mount | grep "$(readlink /DATA/recordfile | sed -e 's,/recordfile,,') " | cut -d' ' -f1`
   RECORDFILE_OLD=`du -sk /DATA/recordfile/ | awk '{ print $1 }'`
fi

REAL_CHECK_PATH=`$realpath $CHECK_PATH`
NEXT_BACKUP_DATE=`cat /PLUGINS/PriorityManager/next_backup_date`
sync

snice STOP PriorityManager.sh

while [ 1 ]; do
   if [ ! -f /tmp/PriorityManager_IsRunning ]; then
      exit 0
   fi

   execute_actions
   swapper
   mounter
   take_backup
   check_log_size
   
   if [ "$PRIORITY_MANAGEMENT" == 1 ]; then
      manage_priority
   else
      check_sleep
      if [ "$SLEEP_SWITCHED" == 1 ]; then
         if [ "$CURRENT_MENU" == "" ]; then
            CURRENT_MENU=START
         elif [ "$CURRENT_MENU" == "SLEEP" ]; then
            CURRENT_MENU=WAKEUP
         else
            CURRENT_MENU=SLEEP
         fi
      fi

      sleep 30
   fi
done

exit 0
