#!/bin/sh
# 
# PRIORITY MANAGER V1.8 BY BUYUKBANG
#
#########################################################################################
#
# PLEASE READ FOLLOWING FILE FOR MORE INFORMATION: /PLUGINS/PriorityManager/readme.txt
#
#########################################################################################

CHECK_SLEEP=0
SLEEP_EVENT=0
WAKEUP_EVENT=0

if [ -f /DISK2/etc/PriorityManagerSettings.txt ]; then
   dos2unix /DISK2/etc/PriorityManagerSettings.txt
   . /DISK2/etc/PriorityManagerSettings.txt
else
   exit
fi

if [ -f /tmp/PriorityManager_Reload_TV_Running ]; then
   exit
fi

echo $? > /tmp/PriorityManager_Reload_TV_Running

if [ "$(cat /DISK2/selene.conf|grep always_tv=|sed 's/always_tv=//')" == '1'  ]; then
   CHECK_SLEEP=1
fi

if [ "$1" == "1" ]; then
   while [ "$WAKEUP_EVENT" == "0" ] && [ "$(cat /DISK2/selene.conf|grep currnt_menu=|sed 's/currnt_menu=//')" != 'TV'  ]; do  
      sleep 2
      if [ "$CHECK_SLEEP" == "1" ]; then
         if [ -f /tmp/PriorityManager_Sleep ]; then
            SLEEP_EVENT=1
         elif [ "$SLEEP_EVENT" == "1" ]; then
            WAKEUP_EVENT=1
         fi
      fi
   done
else
   td210_ip_remote 127.0.0.1 S /PLUGINS/PriorityManager/exit.scr
fi

vfd_display -td210 'STOPPING TV'

chmod 755 /tmp/kill_EMUs.sh; /tmp/kill_EMUs.sh

killall -9 JIPC_Server
killall -9 SDecoderServer
killall -9 rssfeed
killall -9 Polaris
killall -9 browser_control
killall -9 CRTVSetup
killall -9 CRTVCore
killall -9 youtube_player
killall -9 radio_test
killall -9 detector_test
killall -9 DStar
killall -9 EStar
killall -9 JPlugins

rmmod fuse
rmmod sckernel
rmmod em8xxxfb
rmmod em8xxx
rmmod llad

rm -f /tmp/.start_ok /tmp/timestamp

###################################################################

vfd_display -td210 'STARTING TV'

/sbin/insmod /MMP/modules/2.6.15/llad.ko max_dmapool_memory_size=0x800000 max_dmabuffer_log2_size=17
/sbin/insmod /MMP/modules/2.6.15/em8xxx.ko
/sbin/insmod /MMP/modules/2.6.15/sckernel.ko
/sbin/insmod /MMP/modules/2.6.15/fuse.ko

/bin/mknod -m 766 /dev/scard c 182 0
/bin/mknod -m 766 /dev/fuse c 10 229 

/MMP/usr/bin/JIPC_Server &
sleep 2;

/MMP/usr/bin/tuner_detector

rm -f /tmp/decoder_inited /tmp/decoder_dead
/MMP/usr/bin/SDecoderServer 

/MMP/usr/bin/CRTVCore &
/MMP/usr/bin/CRTVSetup &

while [ ! -f /tmp/decoder_inited ]; do
   sleep 1
   if [ -f /tmp/decoder_dead ]; then
      sync;
      /MMP/usr/bin/K.sh
      reboot;
   fi
done

vfd_display -td210 'STARTING UI'
/MMP/usr/bin/DStar &
snice emu_module mgcamd mbox_module sbox.sigma oscam dvbapi_module CCcam.mipsel deformhandlerV1ac newcs newcs.sigma.usb newcs.sigma.pcsc -5

echo $"`date '+%H:%M:%S %m/%d/%y'`": "TV APPLICATIONS RESTARTED" >> /tmp/PriorityManager_IsRunning

if [ "$RUN_AFTER_RETURN_FROM_KILL" != "" ]; then
   $RUN_AFTER_RETURN_FROM_KILL &
   echo $"`date '+%H:%M:%S %m/%d/%y'`":  "$RUN_AFTER_RETURN_FROM_KILL EXECUTED" >> /tmp/PriorityManager_IsRunning
fi

rm -f /tmp/PriorityManager_Reload_TV_Running

exit 0
