#! /bin/sh
export LD_LIBRARY_PATH=/MMP/lib:/MMP/usr/lib
export PATH=/bin:/sbin:/usr/bin:/usr/sbin:/MMP/bin:/MMP/sbin:/MMP/usr/bin:/MMP/usr/sbin

echo "APP>> ACTION = [$ACTION]"
echo "APP>> APP_ID = [$APP_ID]"
echo "APP>> REQ_ID = [$REQ_ID]"

killapp()
{
	[ -n "$1" ] && [ -n "`/bin/pidof $1`" ] && killall -9 $1
}

oom_disable()
{
	for i in `pidof $1` ; do
		echo -17 > /proc/$i/oom_adj
	done
}

/MMP/usr/bin/snice init +0

case "$ACTION" in
	init)
		echo "APP>> init!!!"
		;;

	start|restart)
		case "$APP_ID" in
			1)
				echo "APP>> start ir_control !!!"
				killapp ir_control
				/MMP/usr/bin/ir_control -td210 &
				;;
			2)
				echo "APP>> restart MMP !!!"
				if [ -f /tmp/.start ]; then
					rm -f /tmp/.start
					echo "$REQ_ID" >> /tmp/.restart
					exit;
				fi
				sh /MMP/usr/bin/S.sh &
				;;
			3)
				echo "APP>> start CRTVSetup !!!"
				killapp CRTVSetup
				/MMP/usr/bin/CRTVSetup &
				;;
			4)
				echo "APP>> start CRTVCore !!!"
				killapp CRTVCore
				/MMP/usr/bin/CRTVCore &
				sleep 1
				;;
			5)
				echo "APP>> start update_agent !!!"
				killapp update_agent
				/MMP/usr/bin/update_agent &
				;;
			6)
				echo "app>> start youtube !!!"
				killapp youtube_player
				/MMP/usr/bin/youtube_player &
				;;
			7)
				echo "app>> start rssfeed!!!"
				killapp rssfeed
				/MMP/usr/bin/rssfeed &
				;;
			8)
				echo "app>> start Polaris & browser_control!!!"
				killapp Polaris
				killapp browser_control
				/MMP/usr/bin/Polaris &
				sleep 1;
				/MMP/usr/bin/browser_control &
				;;
			9)
				echo "APP>> ???!!!"
				;;
			10)
				echo "APP>> start file_control !!!"
				killapp file_control
				/MMP/usr/bin/file_control &
				;;
			11)
				echo "APP>> start radio_test !!!"
				killapp radio_test
				/MMP/usr/bin/radio_test 1 &
				;;
			12)
				echo "APP>> start detector_test !!!"
				killapp detector_test
				if [ -f /tmp/.factory ]; then
				/MMP/usr/bin/detector_test open 1 &
				else
				/MMP/usr/bin/detector_test open 0 &
				fi
				;;
			15|16|17)
				echo "APP>> start TVPortal !!!"
				/MMP/usr/bin/dummy_control $APP_ID
				;;
			18)
				echo "APP>> start boot_controler !!!"
				killapp boot_controler
				/MMP/usr/bin/boot_controler &
				;;
			19)	echo "APP>> start admin_control !!!"
				killapp admin_control
				/MMP/usr/bin/admin_control &
				;;
		esac
		;;
esac

exit 0

