#! /bin/sh
export LD_LIBRARY_PATH=/MMP/lib:/MMP/usr/lib
export PATH=/bin:/sbin:/usr/bin:/usr/sbin:/MMP/bin:/MMP/sbin:/MMP/usr/bin:/MMP/usr/sbin

[ -z "$ACTION" ] && echo "Error: should be called from lan_steup" && exit 1

RESOLV_CONF="/etc/resolv.conf"
WPA_CONF="/DISK2/wpa_supplicant.conf"
IF_0="eth0"
IF_1="ra0"

######################################################
### start
######################################################
if [ "$ACTION" = "init" ]; then
	echo "NET_SCRIPT>> load wireless driver rt61!!!"
	killall -9 udhcpc
	insmod /MMP/modules/2.6.15/rt61.ko
	ifconfig $IF_0 up
	ifconfig $IF_1 up
fi
######################################################
### start
######################################################
if [ "$ACTION" = "start" ]; then
	### MODE: 0=cable
	if [ "$MODE" = "0" ]; then
		echo "NET_SCRIPT>> ethernet cable setting..."
		ifconfig $IF_0 0.0.0.0 &
		sleep 1
		[ ! -z "`/bin/pidof ifconfig`" ] && /usr/bin/killall -9 ifconfig
		ifconfig $IF_1 down
		ifconfig $IF_0 up
		### IP_DHCP_MODE: 0=dhcp
		if [ "$IP_DHCP_MODE" = "0" ]; then
			echo "NET_SCRIPT>> ethernet dhcp mode!!!"
		fi
		### IP_DHCP_MODE: 1=static
		if [ "$IP_DHCP_MODE" = "1" ]; then
			ifconfig $IF_0 $IP_ADDR netmask $IP_SUBNET_MASK &
			sleep 2
			if [ ! -z "`/bin/pidof ifconfig`" ] ; then
				/usr/bin/killall -9 ifconfig
				ifconfig $IF_0 $IP_ADDR netmask $IP_SUBNET_MASK &
				sleep 2
			fi
			if [ -n "$IP_GATEWAY" ] ; then
				while route del default gw 0.0.0.0 dev $IF_0 ; do
					:
				done
				for i in $IP_GATEWAY ; do
					route add default gw $i dev $IF_0
				done
			fi
			echo -n > $RESOLV_CONF
			[ -n "$HOST_DOMAIN" ] && echo search $HOST_DOMAIN >> $RESOLV_CONF
			[ -n "$DNS_IP_ADDR1" ] && echo nameserver $DNS_IP_ADDR1 >> $RESOLV_CONF
			[ -n "$DNS_IP_ADDR2" ] && echo nameserver $DNS_IP_ADDR2 >> $RESOLV_CONF
		fi
		echo "NET_SCRIPT>> ethernet cable OK!!!"
	fi
	### MODE: 1=wireless
	if [ "$MODE" = "1" ]; then
		echo "NET_SCRIPT>> wireless setting..."
		insmod /MMP/modules/2.6.15/rt61.ko

		ifconfig $IF_0 0.0.0.0 &
		sleep 1
		[ ! -z "`/bin/pidof ifconfig`" ] && /usr/bin/killall -9 ifconfig

		ifconfig $IF_0 down
		ifconfig $IF_1 up
		iwconfig $IF_1 mode Managed
		[ -n "$HOSTNAME" ] && iwconfig $IF_1 nick $HOSTNAME
		iwconfig $IF_1 channel auto
		iwconfig $IF_1 rate auto

		killall -9 wpa_supplicant

		if [ "$WLAN_ENCYPTION" = "3" ]; then
			echo "NET_SCRIPT>>WPA-PSK"
			echo "ctrl_interface=/var/run/wpa_supplicant" > $WPA_CONF
			echo "network={" >> $WPA_CONF
			wpa_passphrase $WLAN_ESSID $WLAN_KEY >> $WPA_CONF
			echo "scan_ssid=1" >> $WPA_CONF
			echo "proto=WPA RSN" >> $WPA_CONF
			echo "key_mgmt=WPA-PSK" >> $WPA_CONF
			echo "pairwise=CCMP TKIP" >> $WPA_CONF
			echo "group=CCMP TKIP" >> $WPA_CONF
			echo "}" >> $WPA_CONF
			ifconfig $IF_1 up
			wpa_supplicant -B -Dralink -i$IF_1 -c"$WPA_CONF"
		elif [ "$WLAN_ENCYPTION" = "4" ]; then
			echo "NET_SCRIPT>>WPA-EAP"
			echo "ctrl_interface=/var/run/wpa_supplicant" > $WPA_CONF
			echo "network={" >> $WPA_CONF
			wpa_passphrase $WLAN_ESSID $WLAN_KEY >> $WPA_CONF
			echo "scan_ssid=1" >> $WPA_CONF
			echo "proto=WPA RSN" >> $WPA_CONF
			echo "key_mgmt=WPA-EAP" >> $WPA_CONF
			echo "pairwise=CCMP TKIP" >> $WPA_CONF
			echo "group=CCMP TKIP" >> $WPA_CONF
			echo "}" >> $WPA_CONF
			ifconfig $IF_1 up
			wpa_supplicant -B -Dralink -i$IF_1 -c$WPA_CONF
		else
			iwpriv $IF_1 set NetworkType=Infra
			if [ "$WLAN_ENCYPTION" != "0" ] && [ -n "$WLAN_KEY" ]; then
				iwpriv $IF_1 set AuthMode=SHARED
				iwpriv $IF_1 set EncrypType=WEP
				iwpriv $IF_1 set DefaultKeyID=1
				iwpriv $IF_1 set Key1="$WLAN_KEY"
			else
				iwpriv $IF_1 set AuthMode=OPEN
				iwpriv $IF_1 set EncrypType=NONE
			fi
			iwpriv $IF_1 set SSID="$WLAN_ESSID"
		fi

		iwgetid -m $IF_1
		iwgetid -a $IF_1
		iwgetid -c $IF_1
		iwgetid -f $IF_1
		iwgetid -p $IF_1
		iwgetid -r $IF_1

		### IP_DHCP_MODE: 0=dhcp
		if [ "$IP_DHCP_MODE" = "0" ]; then
			echo "NET_SCRIPT>> wireless dhcp mode!!!"
		fi
		### IP_DHCP_MODE: 1=static
		if [ "$IP_DHCP_MODE" = "1" ]; then
			ifconfig $IF_1 $IP_ADDR netmask $IP_SUBNET_MASK &
			sleep 2
			if [ ! -z "`/bin/pidof ifconfig`" ] ; then
				/usr/bin/killall -9 ifconfig
				ifconfig $IF_1 $IP_ADDR netmask $IP_SUBNET_MASK &
				sleep 2
			fi
			if [ -n "$IP_GATEWAY" ] ; then
				while route del default gw 0.0.0.0 dev $IF_1 ; do
					:
				done
				for i in $IP_GATEWAY ; do
					route add default gw $i dev $IF_1
				done
			fi
			echo -n > $RESOLV_CONF
			[ -n "$HOST_DOMAIN" ] && echo search $HOST_DOMAIN >> $RESOLV_CONF
			[ -n "$DNS_IP_ADDR1" ] && echo nameserver $DNS_IP_ADDR1 >> $RESOLV_CONF
			[ -n "$DNS_IP_ADDR2" ] && echo nameserver $DNS_IP_ADDR2 >> $RESOLV_CONF
		fi
		echo "NET_SCRIPT>> wireless OK!!!"
	fi
fi
######################################################
### alive
######################################################
if [ "$ACTION" = "alive" ]; then
	rdate -s time.bora.net &
fi
######################################################
exit 0

