#! /bin/sh
export LD_LIBRARY_PATH=/MMP/lib:/MMP/usr/lib
export PATH=/bin:/sbin:/usr/bin:/usr/sbin:/MMP/bin:/MMP/sbin:/MMP/usr/bin:/MMP/usr/sbin

USBCHECK="/tmp/.start_usb"
UPNPCHECK="/tmp/.upnp"

[ -f "$USBCHECK" ] && exit
touch $USBCHECK

usb_mount()
{
	DEVPATH=$1
	echo "DEVPATH=$DEVPATH"
	DEV_PREFIX=`echo $DEVPATH | awk '{print substr($1,1,8)}'`
	DEV_LIST=`fdisk -l | grep "^$DEV_PREFIX" | awk '{print $1}'`
	MOUNT_HOME="/DATA/usb1"
	[ "$DEV_PREFIX" = "/dev/sda" ] && MOUNT_HOME="/DATA/usb1"
	[ "$DEV_PREFIX" = "/dev/sdb" ] && MOUNT_HOME="/DATA/usb2"
	[ "$DEV_PREFIX" = "/dev/sdc" ] && MOUNT_HOME="/DATA/usb2"
	[ "$DEV_PREFIX" = "/dev/sdd" ] && MOUNT_HOME="/DATA/usb2"
	echo "check mount $DEVPATH..."
	MOUNT_POINT=`df | grep "^$DEVPATH"`
	if [ -z "$MOUNT_POINT" ] ; then
		echo "mount $DEVPATH..."
		FS_INFO=`fdisk -l | grep "^$DEVPATH"`
		FS_TYPE="none"
		[ -n "`echo $FS_INFO | grep Win95`" ] && FS_TYPE="none"
		[ -n "`echo $FS_INFO | grep NTFS`"  ] && FS_TYPE="ntfs"
		[ -n "`echo $FS_INFO | grep FAT`"   ] && FS_TYPE="vfat"
		[ -n "`echo $FS_INFO | grep Linux`" ] && FS_TYPE="ext3"
		DEV_NAME=`echo $DEVPATH | awk -F/ '{print $3}'`
		MOUNT_POINT="$MOUNT_HOME/$DEV_NAME"
		echo "FS_TYPE=$FS_TYPE"
		case "$FS_TYPE" in
			ntfs)
				mkdir -p $MOUNT_POINT
				if [ -f "$UPNP_CHECK" ] 
				then 
					echo "ntfs-3g $DEVPATH $MOUNT_POINT"
					ntfs-3g $DEVPATH $MOUNT_POINT -o defaults,locale=ko_KR.UTF-8
				else
					echo "mount -t ntfs $DEVPATH $MOUNT_POINT"
					mount -t ntfs $DEVPATH $MOUNT_POINT -o ro,nls=utf8
				fi
				[ $? != 0 ] && rmdir $MOUNT_POINT
				;;
			vfat)
				echo "mount -t vfat $DEVPATH $MOUNT_POINT"
				mkdir -p $MOUNT_POINT
				mount -t vfat $DEVPATH $MOUNT_POINT -o rw,noexec,nosuid,nodev,noatime,uid=0,utf8
				[ $? != 0 ] && rmdir $MOUNT_POINT
				;;
			ext3)
				echo "mount -t ext3 $DEVPATH $MOUNT_POINT"
				mkdir -p $MOUNT_POINT
#				mount -t ext3 $DEVPATH $MOUNT_POINT
				mount $DEVPATH $MOUNT_POINT
				[ $? != 0 ] && rmdir $MOUNT_POINT
				;;
			none)
				case "$DEVPATH" in
					"/dev/sda" |"/dev/sdb" |"/dev/sdc" |"/dev/sdd")
						echo "mount -t auto $DEVPATH $MOUNT_POINT"
						mkdir -p $MOUNT_POINT
						mount -t auto $DEVPATH $MOUNT_POINT -o rw,noexec,nosuid,nodev,noatime,uid=0,utf8
						[ $? != 0 ] && rmdir $MOUNT_POINT
						;;
				esac
				;;
		esac

  fi
}
######################################################
### INIT
######################################################
if [ "$ACTION" = "init" ]; then
  #insmod /MMP/modules/2.6.15/cdrom.ko 
  #insmod /MMP/modules/2.6.15/sr_mod.ko
	#insmod scsi_mod.ko
	#insmod sd_mod.ko
	#insmod sg.ko
	#rmmod usb-storage
	#rmmod tangox-ehci-hcd
	#insmod tangox-ehci-hcd.ko
	#insmod usb-storage.ko
	#lsmod
	DIR_HOME="/DATA/usb1"
	DIR_LIST=`ls $DIR_HOME`
	for i in $DIR_LIST ; do
		if [ -z "`df | grep "^/dev/$i"`" ] ; then
			rmdir $DIR_HOME/$i
		fi
	done
	DIR_HOME="/DATA/usb2"
	DIR_LIST=`ls $DIR_HOME`
	for i in $DIR_LIST ; do
		if [ -z "`df | grep "^/dev/$i"`" ] ; then
			rmdir $DIR_HOME/$i
		fi
	done

	DEV_LIST=`cat /proc/partitions | grep 'sd[a-z][1-9]' | awk '{print $4}' | sort`
	for i in $DEV_LIST ; do
		usb_mount "/dev/$i"
	done
	
fi
######################################################
### ADD
######################################################
if [ "$ACTION" = "add" ]; then
	if [ "$SUBSYSTEM" = "usb_device" ]; then
		#for i in `find /sys$DEVPATH/device/ -type f` ; do
		#	[ -r $i ] && echo "$i = `cat $i`"
		#done
		USB_SPEED=`cat /sys$DEVPATH/device/speed`
		echo "add USB_SPEED=$USB_SPEED"
	fi
fi
######################################################
### REMOVE
if [ "$ACTION" = "remove" ]; then
	if [ "$SUBSYSTEM" = "usb_device" ]; then
		echo "remove USB device!!!"
	fi
fi
######################################################
### MOUNT
######################################################
if [ "$ACTION" = "mount" ] ; then
	usb_mount $DEVPATH
fi
######################################################
### UMOUNT
######################################################
if [ "$ACTION" = "umount" ]; then
	echo "umount $DEVPATH"
	MOUNT_POINT=`mount | grep "^$DEVPATH" | awk '{print $3}'`
	if [ -n "$MOUNT_POINT" ] ; then
		umount $DEVPATH
	fi
	MOUNT_CHECK=`mount | grep "^$DEVPATH"`
	if [ -z "$MOUNT_CHECK" ] ; then
		DEV_PREFIX=`echo $DEVPATH | awk '{print substr($1,1,8)}'`
		MOUNT_HOME="/DATA/usb1"
		[ "$DEV_PREFIX" = "/dev/sda" ] && MOUNT_HOME="/DATA/usb1"
		[ "$DEV_PREFIX" = "/dev/sdb" ] && MOUNT_HOME="/DATA/usb2"
		[ "$DEV_PREFIX" = "/dev/sdc" ] && MOUNT_HOME="/DATA/usb2"
		[ "$DEV_PREFIX" = "/dev/sdd" ] && MOUNT_HOME="/DATA/usb2"
		DEV_NAME=`echo $DEVPATH | awk -F/ '{print $3}'`
		MOUNT_POINT="$MOUNT_HOME/$DEV_NAME"
		rmdir "$MOUNT_POINT"
	fi
fi
######################################################
rm -f $USBCHECK

