#! /bin/sh
export LD_LIBRARY_PATH=/MMP/lib:/MMP/usr/lib
export PATH=/bin:/sbin:/usr/bin:/usr/sbin:/MMP/bin:/MMP/sbin:/MMP/usr/bin:/MMP/usr/sbin

######################################################
### START
######################################################
if [ "$ACTION" = "start" ]; then
	mkdir -p /DATA/dstar/samba
	mkdir -p /DATA/dstar/samba/log
	SMB_CONF='/DATA/dstar/samba/smb.conf'
	SMB_USERS='/DATA/dstar/samba/smbusers'
	SMB_PASSWD='/DATA/dstar/samba/smbpasswd'
	echo "$USER_ID = samba user" > $SMB_USERS
	echo "" > $SMB_PASSWD
	SMB_GUEST='yes'
	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
		echo "user_id = $USER_ID"
		echo "password = $PASSWORD"
		echo "$PASSWORD" > /tmp/smbpasswd
		echo "$PASSWORD" >> /tmp/smbpasswd
		grep "^$USER_ID" /etc/passwd
		if [ $? != 0 ] ; then
			adduser "$USER_ID" < /tmp/smbpasswd
		fi
		/MMP/usr/bin/smbpasswd -c /DATA/dstar/samba/smbpasswd -s -a "$USER_ID" < /tmp/smbpasswd
		SMB_GUEST='no'
	fi
	SMB_SHARED=/DATA/shared
	mkdir -p $SMB_SHARED
	rm -f $SMB_SHARED/*
	ln -s /DATA/movie $SMB_SHARED/movie
	ln -s /DATA/music $SMB_SHARED/music
	ln -s /DATA/picture $SMB_SHARED/picture
	ln -s /DATA/download $SMB_SHARED/download
	/bin/sh /MMP/usr/bin/smb_chmod.sh &
	echo "[global]" > $SMB_CONF
	echo "   workgroup = $WORKGROUP" >> $SMB_CONF
	echo "   server string = $SERVER" >> $SMB_CONF
	echo "   cups options = raw" >> $SMB_CONF
	echo "   log file = /DATA/dstar/samba/log/samba/%m.log" >> $SMB_CONF
	echo "   max log size = 50" >> $SMB_CONF
	echo "   dns proxy = no" >> $SMB_CONF
	echo "   encrypt passwords = yes" >> $SMB_CONF
	echo "   smb passwd file = /DATA/dstar/samba/smbpasswd" >> $SMB_CONF
	
	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
		echo "   map to guest = bad user" >> $SMB_CONF
		echo "   security = user" >> $SMB_CONF
	else
		echo "   security = share" >> $SMB_CONF
	fi

#	echo "[homes]" >> $SMB_CONF
#	echo "   comment = Home Directories" >> $SMB_CONF
#	echo "   browseable = no" >> $SMB_CONF
#	echo "   writeable = no" >> $SMB_CONF
	#################################################
##	echo "[shared]" >> $SMB_CONF
#	echo "[DStar]" >> $SMB_CONF
#	echo "   path = $SMB_SHARED" >> $SMB_CONF
#	echo "   writeable = yes" >> $SMB_CONF
#	echo "   browseable = yes" >> $SMB_CONF
#	echo "   guest ok = $SMB_GUEST" >> $SMB_CONF
#	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
#		echo "   public = no" >> $SMB_CONF
#		echo "   valid users = $USER_ID" >> $SMB_CONF
#	fi
	#################################################
	echo "[movie]" >> $SMB_CONF
	echo "   path = /DATA/movie" >> $SMB_CONF
	echo "   writeable = yes" >> $SMB_CONF
	echo "   browseable = yes" >> $SMB_CONF
	echo "   guest ok = $SMB_GUEST" >> $SMB_CONF
	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
		echo "   public = no" >> $SMB_CONF
		echo "   valid users = $USER_ID" >> $SMB_CONF
	fi
	
	echo "[music]" >> $SMB_CONF
	echo "   path = /DATA/music" >> $SMB_CONF
	echo "   writeable = yes" >> $SMB_CONF
	echo "   browseable = yes" >> $SMB_CONF
	echo "   guest ok = $SMB_GUEST" >> $SMB_CONF
	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
		echo "   public = no" >> $SMB_CONF
		echo "   valid users = $USER_ID" >> $SMB_CONF
	fi
	
	echo "[picture]" >> $SMB_CONF
	echo "   path = /DATA/picture" >> $SMB_CONF
	echo "   writeable = yes" >> $SMB_CONF
	echo "   browseable = yes" >> $SMB_CONF
	echo "   guest ok = $SMB_GUEST" >> $SMB_CONF
	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
		echo "   public = no" >> $SMB_CONF
		echo "   valid users = $USER_ID" >> $SMB_CONF
	fi
	
	echo "[download]" >> $SMB_CONF
	echo "   path = /DATA/download" >> $SMB_CONF
	echo "   writeable = yes" >> $SMB_CONF
	echo "   browseable = yes" >> $SMB_CONF
	echo "   guest ok = $SMB_GUEST" >> $SMB_CONF
	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
		echo "   public = no" >> $SMB_CONF
		echo "   valid users = $USER_ID" >> $SMB_CONF
	fi
	
	echo "[recordfile]" >> $SMB_CONF
	echo "   path = /DATA/recordfile" >> $SMB_CONF
	echo "   writeable = yes" >> $SMB_CONF
	echo "   browseable = yes" >> $SMB_CONF
	echo "   guest ok = $SMB_GUEST" >> $SMB_CONF
	if [ "$USER_ID" != "" ] && [ "$PASSWORD" != "" ]; then
		echo "   public = no" >> $SMB_CONF
		echo "   valid users = $USER_ID" >> $SMB_CONF
	fi
	
#ygkwon 2010-04-07
#	echo "$SERVER" > /etc/hostname
#	hostname $SERVER

	killall -9 nmbd
	killall -9 smbd
	umask 0777
	/MMP/usr/sbin/nmbd -D
	/MMP/usr/sbin/smbd -D
fi
######################################################

######################################################
### STOP
######################################################
if [ "$ACTION" = "stop" ]; then
	killall -9 find
	killall -9 chmod
	killall -9 nmbd
	killall -9 smbd
fi
######################################################

