#!/bin/sh
export LD_LIBRARY_PATH=/usr/local/lib
export PATH=/bin:/sbin:/usr/bin:/usr/sbin

echo "check hda"

if [ -z $1 ]; then
	MAKE_PARTITION=0
else
	MAKE_PARTITION=$1
fi

/sbin/fdisk -l /dev/hda | grep hda 
if [ $? = 1 ]; then
	while [ /bin/true ]; do
		/DISK1/system_tools/vfd_display -td210 'Err:NO_DISK'
		sleep 3
		/DISK1/system_tools/vfd_display -td210 'Connect AS'
		sleep 3
	done
fi

/sbin/fdisk -l /dev/hda | grep hda1 | grep Linux > /dev/null
[ $? = 1 ] && MAKE_PARTITION=1
/sbin/fdisk -l /dev/hda | grep hda2 | grep Linux > /dev/null
[ $? = 1 ] && MAKE_PARTITION=1
/sbin/fdisk -l /dev/hda | grep hda3 | grep Linux > /dev/null
[ $? = 1 ] && MAKE_PARTITION=1
/sbin/fdisk -l /dev/hda | grep hda4 | grep Linux > /dev/null
[ $? = 1 ] && MAKE_PARTITION=1

if [ $MAKE_PARTITION = 1 ] ; then
	/DISK1/hdd_tools/format_hda.sh
fi

mount -t ext3 -o ro /dev/hda1 /MMP
if [ $? = 1 ]; then
	echo "Fail to mount /dev/hda1"
fi


rm /USER
rmdir /EMU
mkdir /PLUGINS
ln -s /PLUGINS /USER

mount -t ext3 /dev/hda2 /PLUGINS
if [ $? = 1 ]; then
	echo "Fail to mount /dev/hda2"
else	
	if [ $MAKE_PARTITION = 1 ] ; then
		echo "Recovery PLUGINS home directories"
		mkdir -p /PLUGINS/home/stbuser
		chown stbuser:stbuser /PLUGINS/home/stbuser
	fi

	if [ -d "/PLUGINS/OpenXCAS" ] ; then
		ln -s /PLUGINS /EMU
	elif [ -d "/PLUGINS/BISS" ] ; then
		ln -s /PLUGINS /EMU
	fi
fi

mount -t ext3 /dev/hda3 /DISK2
if [ $? = 1 ]; then
	echo "Fail to mount /dev/hda3"
else
	if [ $MAKE_PARTITION = 1 ] ; then
		echo "Recovery DISK2 files"
		cp -af /DISK1/DISK2_backup/* /DISK2/ 
	fi
fi

mount -t ext3 /dev/hda4 /Download
if [ $? = 1 ]; then
	echo "Fail to mount /dev/hda4"
fi

if [ -e /MMP/PriorityManager.tar.gz ] ; then
	tar -xvzf /MMP/PriorityManager.tar.gz -C /PLUGINS
	chmod -R 755 /PLUGINS/PriorityManager
	/PLUGINS/PriorityManager/sh/install.sh
	rm /MMP/PriorityManager.tar.gz
	cp /DISK1/DISK2_backup/PriorityManagerSettings.txt /DISK2/etc/
fi

/DISK1/hdd_tools/encrypt_HDD /dev/hda

chmod 700 /Download
chmod 700 /DISK2

