#!/bin/sh

export LD_LIBRARY_PATH=/usr/local/lib

UPDATE=/usr/local/bin/hx_update
REBOOT=/tmp/rcPatch

UPDATE_TOOL_PATH=/usr/local

CMD_UPDATE=./bin/hx_update

CMD_VFD_OUT=/DISK1/system_tools/vfd_display
	
MODULE_PATH=/usr/local/modules/2.6.15

RECOVERY_RESULT_FILE=/tmp/.need_recovery
UPDATE_RESULT_FILE=/MMP/.update_done
INTEGRITY_FILE=/MMP/.integrity_check_list
DEBUG=/DISK1/.debug

# change passwd to my one

cp -f /DISK1/system_tools/change_passwd /bin/passwd

# check whether current mode is debug or not

if [ -f $DEBUG ]
then
	$CMD_VFD_OUT -td210 '__ DEBUG __'
	touch /tmp/.debug
#	touch /tmp/.debug_event
	touch /tmp/.debug_ir

	cp -f /DISK1/.passwd.debug /etc/passwd
	cp -f /DISK1/.shadow.debug /etc/shadow

	exit 0;
else
	cp -f /DISK1/.passwd /etc/passwd
	cp -f /DISK1/.shadow /etc/shadow
fi

need_recovery=0;

$CMD_VFD_OUT -td210 'CHECKING.'

if [ $need_recovery -eq 0 ]; then

	# Wait for checking user break
	echo "Check whether break by user or not"

	/usr/local/bin/hx_check_front -m TD210 -w 2 "CHECKING.."

	if [ $? -eq 1 ]; then
		echo "Break by User"
		need_recovery=4;
	else
		echo "No event in front receiver"

		# Update test code
		#cp -af /usr/local /tmp/
		#cp -af /DISK1/system_tools/rcPatch /tmp/

		#/sbin/reboot
		#exit 0;
	fi
fi


$CMD_VFD_OUT -td210 'CHECKING..'

find_boot_files=0;

if [ $need_recovery -eq 0 ]; then

	# Check whether patch files is in USB storage or not
	if [ -d "/proc/scsi/usb-storage/" ]; then

$CMD_VFD_OUT -td210 'USB S..'
		# Wait for searching USB storage
		echo "USB storage is connected"
		echo "Wait 5 second for searching USB storage"

		sleep 5;

		#fdisk -l | grep '^/dev/sd' | grep 'FAT'
		fdisk -l | grep '^/dev/sd'
		if [ $? = 0 ] ; then

$CMD_VFD_OUT -td210 'MOUNT USB'
			echo "Mount USB storage"
			mount -o ro -t vfat /dev/sda1 /mnt
			if [ $? = 0 ] ; then
				if [ -f "/mnt/factory.cramfs" ]; then
					find_boot_files=1;
				elif [ -f "/mnt/patch.bin" ]; then
					find_boot_files=1;
				else
					umount /mnt
				fi
			fi

			if [ $find_boot_files -eq 0 ]; then
				mount -o ro -t vfat /dev/sda /mnt
				if [ $? = 0 ] ; then
					if [ -f "/mnt/factory.cramfs" ]; then
						find_boot_files=1;
					elif [ -f "/mnt/patch.bin" ]; then
						find_boot_files=1;
					else
						umount /mnt
					fi
				fi
			fi

			if [ $find_boot_files -eq 0 ]; then
				mount -o ro -t vfat /dev/sdb1 /mnt
				if [ $? = 0 ] ; then
					if [ -f "/mnt/factory.cramfs" ]; then
						find_boot_files=1;
					elif [ -f "/mnt/patch.bin" ]; then
						find_boot_files=1;
					else
						umount /mnt
					fi
				fi
			fi

			if [ $find_boot_files -eq 0 ]; then
				mount -o ro -t vfat /dev/sdb /mnt
				if [ $? = 0 ] ; then
					if [ -f "/mnt/factory.cramfs" ]; then
						find_boot_files=1;
					elif [ -f "/mnt/patch.bin" ]; then
						find_boot_files=1;
					else
						umount /mnt
					fi
				fi
			fi

			if [ $find_boot_files -eq 1 ]; then
				echo "Find factory test program"
				if [ -f "/mnt/factory.cramfs" ]; then
$CMD_VFD_OUT -td210 'FOUND FACTO'
					echo "Found factory test prgram in USB storage"

					mount -t cramfs /mnt/factory.cramfs /Patch -o loop

					/Patch/factory_test.sh	

					umount /Patch

				else
					echo "Not found factory test program in USB storage"
					echo "Find and Check patch files"
					if [ -f "/mnt/patch.bin" ]; then
						echo "Found patch file in USB storage"
						need_recovery=5;
					else
						echo "Not found patch file in USB storage"
					fi
				fi
			
				umount /mnt

			else
				echo "Not mount USB storage to /dev/sda1"
			fi
		else
			echo "Not found valid USB storage for updating"
		fi
	fi
fi

$CMD_VFD_OUT -td210 'CHECKING...'

if [ $need_recovery -eq 0 ]; then
	# check whether last update is valid or not
	if [ -f $UPDATE_RESULT_FILE ]; then
		echo "Last updating is done, sucessfully"
	else
		echo "Fail to update last time"
		need_recovery=1;
	fi
fi


if [ $need_recovery -eq 0 ]; then

	# check whether core files in MMP directory is valid or not
	if [ -f $INTEGRITY_FILE ]; then

		exec < $INTEGRITY_FILE
		while read line 
		do
			md5checksum=${line:0:32}
			filename=${line:33:40}
			echo -n "Checking integrity of '$filename' ($md5checksum)..."

			if [ -f $filename ]; then
				result=`/usr/bin/md5sum $filename`

				result_val=${result:0:32}
				if [ $result_val = $md5checksum ]
				then
					echo "OK [ $result_val ]"
				else
					echo "Not OK [ $result_val ]"
				fi
			else
				echo "Not OK [file not exist]"
			fi
		done
	else
		echo "Can not find $INTEGRITY_FILE"
		need_recovery=3;
	fi
fi


if [ $need_recovery -ne 0 ]; then
	echo "Start recovery program"

	insmod $MODULE_PATH/llad.ko
	insmod $MODULE_PATH/em8xxx.ko

	cd $UPDATE_TOOL_PATH

	if [ $need_recovery -eq 1 ]; then
		# LAST UPDATE is fail
		echo "Last updating is fail"
	
		$CMD_UPDATE -m TD210 -t "Last updating is fail (error=1)" -s "Please, select update method"

	elif [ $need_recovery -eq 2 ]; then
		# Intergrity of files is invalid
		echo "Intergrity of files is invalid"

		$CMD_UPDATE -m TD210 -t "System is crashed (error=2)" -s "Please, select update method"

	elif [ $need_recovery -eq 3 ]; then
		# Not exist intergrity file
		echo "Not exist intergrity file"

		$CMD_UPDATE -m TD210 -t "Last updating is fail (error=3)" -s "Please, select update method"

	elif [ $need_recovery -eq 4 ]; then
		# User have broken booting for updating
		echo "User have broken booting for updating"

		$CMD_UPDATE -m TD210 -t "Do you want to update?" -s "Please, select update method"

	elif [ $need_recovery -eq 5 ]; then
		# Found Patch files in USB storage
		echo "Found patch files in USB storage"

		$CMD_UPDATE -m TD210 -t "Found patch files in USB storage?" -s "Do you want to update?"

	else
		# Unknown status
		echo "Unknown status: Do you want to update?"

		$CMD_UPDATE -m TD210 -t "System is crashed (error=6)" -s "Please, select update method"

	fi

	cd -

	rmmod em8xxx
	rmmod llad
	
	if [ -f $RECOVERY_RESULT_FILE ]; then
		cp -af /usr/local /tmp/
		cp -af /DISK1/system_tools/rcPatch /tmp/

		/sbin/reboot

		exit 0;
	fi
fi

$CMD_VFD_OUT -td210 'STARTING...'

# Start all init scripts in /DISK2/etc/service.d
# executing them in numerical order.
#


killall -9 telnetd

for i in /DISK2/etc/service.d/S??* ;do

     # Ignore dangling symlinks (if any).
     [ ! -f "$i" ] && continue

     case "$i" in
	*.sh)
	    # Source shell script for speed.
	    (
		trap - INT QUIT TSTP
		set start
		. $i
	    )
	    ;;
	*)
	    # No sh extension, so fork subprocess.
	    $i start
	    ;;
    esac
done


echo "Start main program"

/MMP/usr/bin/S.sh

