#! /bin/sh
echo "[Debug Mode] Begin of start.sh ###"
export LD_LIBRARY_PATH=/MMP/lib:/PLUGINS/ExtLib:/MMP/usr/lib:/lib:/usr/lib
export PATH=/bin:/sbin:/usr/bin:/usr/sbin:/MMP/bin:/MMP/sbin:/MMP/usr/bin:/MMP/usr/sbin:/MMP/usr/bin/test

export MALLOC_CHECK_=3

# led reset
vfd_display -td210 -led roff
vfd_display -td210 -led goff

if [ -f /tmp/.front_pavo ] ; then
	FAN_EXIST="yes"
	vfd_display -td210 -fan on
fi

if [ -f /tmp/.front_aries ] ; then
	FAN_EXIST="yes"
	vfd_display -td210 -fan on
fi

# Increase message queue size
echo 262144 > /proc/sys/kernel/msgmnb

mkdir /DATA/meta/ 

proc_nice()
{
	/MMP/usr/bin/snice $1 -5
}

debug_print()
{
	echo "$1>>`date`" >> /tmp/timestamp
}

vfd_display -td210 'LOADING.  '
rm -f /tmp/timestamp
debug_print "1"
DISK2_HOME=`if [ -f /tmp/.disk2 ]; then cat /tmp/.disk2; else echo "/DISK2"; fi`
SSCHECK=/tmp/.start
SSOK=/tmp/.start_ok
INTERFACES=/DISK2/interfaces

#/sbin/hdparm -S 120 /dev/hdb

if [ -f $SSCHECK ] ; then
	echo "skip...."
	exit 0;
fi

if [ -f $INTERFACES ] ; then
echo "interfaces ok"
else
echo "auto lo" >> $INTERFACE
echo "iface lo inet loopback" >> $INTERFACES
echo "auto eth0" >> $INTERFACES
echo "iface eth0 inet dhcp" >> $INTERFACES
ifup eth0
fi

touch $SSCHECK
if [ -f $SSOK ] ; then
	K.sh
	sleep 1
	K.sh
fi

#[ -n "`/bin/pidof udhcpc`" ] && killall -9 udhcpc

#/MMP/usr/bin/event_dispatcher &

vfd_display -td210 'LOADING.. '
debug_print "2"
# max_dmabuffer_log2_size :
# 15/16/17/18 = 32KB/64KB/128KB/256KB
#/sbin/insmod /MMP/modules/2.6.15/llad.ko
/sbin/insmod /MMP/modules/2.6.15/llad.ko max_dmapool_memory_size=0x800000 max_dmabuffer_log2_size=17
#/sbin/insmod /MMP/modules/2.6.15/llad.ko max_dmapool_memory_size=0x600000 max_dmabuffer_log2_size=16
#/sbin/insmod /MMP/modules/2.6.15/llad.ko max_dmapool_memory_size=0x800000 max_dmabuffer_log2_size=18
/sbin/insmod /MMP/modules/2.6.15/em8xxx.ko
/sbin/insmod /MMP/modules/2.6.15/sckernel.ko
/sbin/insmod /MMP/modules/2.6.15/usbserial.ko
/sbin/insmod /MMP/modules/2.6.15/ftdi_sio.ko
/sbin/insmod /MMP/modules/2.6.15/cdrom.ko
/sbin/insmod /MMP/modules/2.6.15/sr_mod.ko
/sbin/insmod /MMP/modules/2.6.15/cdfs.ko
/sbin/insmod /MMP/modules/2.6.15/fuse.ko

/sbin/insmod /MMP/modules/2.6.15/rt61.ko
/sbin/insmod /MMP/modules/2.6.15/rt3070sta.ko
/sbin/insmod /MMP/modules/2.6.15/rt2500.ko
ifconfig ra0 up

/bin/mknod -m 766 /dev/scard c 182 0
/bin/mknod -m 766 /dev/fuse c 10 229 

/MMP/usr/bin/SecurityCheck

debug_print "3"

/MMP/usr/bin/JIPC_Server &
#/MMP/usr/bin/app_control &

sleep 2;

/MMP/usr/bin/tuner_detector

debug_print "4"

if [ -f /tmp/TUNER_NONE ] ; then
	if [ $FAN_EXIST = "yes" ] ; then
		vfd_display -td210 -fan off
	fi
fi

#killall -9 update_agent
#/MMP/usr/bin/update_agent &

debug_print "5"

################################################### djmount
UPNP_MNT_DIR=/DATA/upnp
UPNP_USHARE=`cat /DISK2/selene.conf | grep upnp_mode= | cut -d= -f2`
/MMP/usr/bin/fusermount -u $UPNP_MNT_DIR
sync
/MMP/usr/bin/djmount $UPNP_MNT_DIR -o iocharset=UTF-8 

if [ $UPNP_USHARE -eq 1 ] ; then
	/MMP/etc/init.d/ushare stop
else
	/MMP/etc/init.d/ushare restart 
fi
###################################################

rm -f /tmp/decoder_inited
rm -f /tmp/decoder_dead
if [ -f /tmp/.debug ] ; then
	mv /DATA/hdb1/pvrlog /DATA/hdb1/pvrlog.prev
	touch /DATA/hdb1/pvrlog
	ln -s /DATA/hdb1/pvrlog /tmp/pvrlog
	/MMP/usr/bin/SDecoderServer -2
else
	/MMP/usr/bin/SDecoderServer 
fi

if ps -aux | grep -v grep | grep djmount > /dev/null 2>&1 ; then 
	echo "use upnp" 
	touch /tmp/.upnp	
else
	echo "not use upnp" 
	rm /tmp/.upnp	
fi

/MMP/usr/bin/ir_control -td210 &
/MMP/usr/bin/file_control &
/MMP/usr/bin/CRTVCore &
/MMP/usr/bin/CRTVSetup &

vfd_display -td210 'LOADING...'
while [ ! -f /tmp/decoder_inited ]; do
	sleep 1
	if [ -f /tmp/decoder_dead ]; then
		sync;
		/MMP/usr/bin/K.sh
		reboot;
	fi
done

# Polaris files
tar zxf /MMP/WriteDir.tgz -C /tmp/

# Default System Language
LANGID=$( cat /DISK2/selene.conf | grep language= | cut -d= -f2 )
if [ -z "$LANGID" ]; then
	LANGID=0
fi
if [ ! -d /DISK2/message ]; then
	/bin/sh /MMP/usr/bin/setup_language.sh ${LANGID}
fi

debug_print "6"
/MMP/usr/bin/DStar &
#/MMP/usr/bin/DStar 2> /dev/console &
debug_print "7"

sleep 3

touch $SSOK
rm -f $SSCHECK

#oom_disable event_dispatcher
#oom_disable app_control
#oom_disable ir_control
#oom_disable file_control
#oom_disable update_agent
#oom_disable SDecoderServer
#oom_disable DStar
#proc_nice event_dispatcher
#proc_nice app_control
#proc_nice ir_control
#proc_nice file_control
proc_nice DStar

#sh /MMP/usr/bin/update_script.sh &


# User defined scripts
# Start all init scripts in /DISK2/etc/start.d
# executing them in numerical order.
#
for i in /DISK2/etc/start.d/S??* ;do

     # Ignore dangling symlinks (if any).
     [ ! -f "$i" ] && continue

     case "$i" in
	*.sh)
	    # Source shell script for speed.
	    (
		trap - INT QUIT TSTP
		set start
		. $i
	    )
	    ;;
	*)
	    # No sh extension, so fork subprocess.
	    $i start
	    ;;
    esac
done

