#!/bin/sh

# udhcpc script edited by Tim Riker <Tim@Rikers.org>

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1

RESOLV_CONF="/etc/resolv.conf"
[ -n "$broadcast" ] && BROADCAST="broadcast $broadcast"
[ -n "$subnet" ] && NETMASK="netmask $subnet"

echo ">>>>> DHCP $1 <<<<<"
case "$1" in
	deconfig)
		/sbin/ifconfig $interface 0.0.0.0 &
		/bin/sleep 1
		[ ! -z "`/bin/pidof ifconfig`" ] && /usr/bin/killall -9 ifconfig
		;;

	renew|bound)
		[ ! -z "`/bin/pidof ifconfig`" ] && killall -9 ifconfig
		/sbin/ifconfig $interface $ip $BROADCAST $NETMASK &
		/bin/sleep 2
		if [ ! -z "`/bin/pidof ifconfig`" ] ; then
			/usr/bin/killall -9 ifconfig
			/sbin/ifconfig $interface $ip $BROADCAST $NETMASK &
			/bin/sleep 2
		fi
		if [ -n "$router" ] ; then
			echo "deleting routers"
			while [ ! -z "`/sbin/route | grep default | grep $interface`" ] ; do
				/sbin/route del default gw 0.0.0.0 dev $interface
			done
			for i in $router ; do
				echo adding gateway $i
				/sbin/route add default gw $i dev $interface
			done
		fi
		echo -n > $RESOLV_CONF
		[ -n "$domain" ] && echo search $domain >> $RESOLV_CONF
		for i in $dns ; do
			echo adding dns $i
			echo nameserver $i >> $RESOLV_CONF
		done
		dns_count=`cat /etc/resolv.conf | grep nameserver | wc -l`
		if [ $dns_count -eq 0 ] ; then
			# ns.kornet.net = [211.216.50.150]
			echo "nameserver 211.216.50.150" >> $RESOLV_CONF
			# ns.hanfos.net = [211.110.201.41]
			echo "nameserver 211.110.201.41" >> $RESOLV_CONF
		fi
		[ ! -z "`/bin/pidof rdate`" ] && /usr/bin/killall -9 rdate
		/usr/sbin/rdate -s time.bora.net &
		;;
esac

exit 0
